; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "XCircuit-dev-tcl"
!define PRODUCT_VERSION "3.7"
!define PRODUCT_REVISION "21"
!define PRODUCT_PUBLISHER "Tim Edwards"
!define PRODUCT_WEB_SITE "http://opencircuitdesign.com/xcircuit/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\xcircuit-dev-win32.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"
!include "Sections.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYRIGHT"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
Page custom WishExePage WishExeValidate
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\bin\xcircuit-win32.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION} (revision ${PRODUCT_REVISION})"
OutFile "Setup-dev-tcl.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
!insertmacro MUI_INSTALLOPTIONS_EXTRACT "wishexe.ini"
FunctionEnd

Section "XCircuit" SEC01
  SetOutPath "$INSTDIR\bin"
  SetOverwrite ifnewer
  File "xcircuit-win32.exe"
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\XCircuit.lnk" "$INSTDIR\bin\xcircuit-win32.exe"
  CreateShortCut "$DESKTOP\${PRODUCT_NAME}.lnk" "$INSTDIR\bin\xcircuit-win32.exe"
  File "lib\tcl\xcircuit.bat"
  SetOutPath "$INSTDIR\xcircuit-${PRODUCT_VERSION}"
  File "lib\tcl\autoincr.tcl"
  File "lib\tcl\bparams.tcl"
  File "lib\tcl\console.tcl"
  File "lib\tcl\files.tcl"
  File "lib\tcl\library.tcl"
  File "lib\tcl\mousehint.tcl"
  File "lib\tcl\ngspice.tcl"
  File "lib\tcl\panzoom.tcl"
  File "lib\tcl\pcbout.tcl"
  File "lib\tcl\xcircuit.tcl"
  File "lib\tcl\wrapper.tcl"
  File "lib\tcl\tkcon.tcl"
  File "lib\tcl\sue_xc.tcl"
  File "lib\tcl\resource.tcl"
  File "lib\tcl\xcstartup.tcl"
  File "lib\tcl\sinusoid.tcl"
  File "lib\tcl\symbol.tcl"
  File "lib\tcl\xchelp.tcl"
  File "lib\tcl\xcircuit.dll"
  File "xcircexec.exe"
  File "lib\signal.lps"
  File "lib\series74xx.lps"
  File "lib\quadparts.lps"
  File "lib\pcb_layout.lps"
  File "lib\pcb.lps"
  File "lib\musiclib.lps"
  File "lib\lgf.lps"
  File "lib\ic_templates.lps"
  File "lib\generic.lps"
  File "lib\digital.lps"
  File "lib\avlsi.lps"
  File "lib\asg_spice.lps"
  File "lib\analoglib3.lps"
  File "lib\analoglib2.lps"
  File "lib\analog.lps"
  File "lib\xspice.lps"
  File "lib\xcircps2.pro"
  SetOutPath "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts"
  File "lib\fonts\times_romaniso.xfe"
  File "lib\fonts\times_romaniso5.xfe"
  File "lib\fonts\times_romaniso5.lps"
  File "lib\fonts\times_romaniso2.xfe"
  File "lib\fonts\times_romaniso2.lps"
  File "lib\fonts\times_roman.xfe"
  File "lib\fonts\times_roman.lps"
  File "lib\fonts\symbol.xfe"
  File "lib\fonts\symbol.lps"
  File "lib\fonts\myfont.xfe"
  File "lib\fonts\myfont.lps"
  File "lib\fonts\helveticaiso.xfe"
  File "lib\fonts\helveticaiso5.xfe"
  File "lib\fonts\helveticaiso5.lps"
  File "lib\fonts\helveticaiso2.xfe"
  File "lib\fonts\helveticaiso2.lps"
  File "lib\fonts\helvetica.xfe"
  File "lib\fonts\helvetica.lps"
  File "lib\fonts\courieriso.xfe"
  File "lib\fonts\courieriso5.xfe"
  File "lib\fonts\courieriso5.lps"
  File "lib\fonts\courieriso2.xfe"
  File "lib\fonts\courieriso2.lps"
  File "lib\fonts\courier.xfe"
  File "lib\fonts\courier.lps"
  SetOutPath "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps"
  File "lib\pixmaps\z4.gif"
  File "lib\pixmaps\yp.gif"
  File "lib\pixmaps\xcircuit.gif"
  File "lib\pixmaps\w.gif"
  File "lib\pixmaps\uj.gif"
  File "lib\pixmaps\tp.gif"
  File "lib\pixmaps\ti.gif"
  File "lib\pixmaps\tg.gif"
  File "lib\pixmaps\t.gif"
  File "lib\pixmaps\s.gif"
  File "lib\pixmaps\q.gif"
  File "lib\pixmaps\pz.gif"
  File "lib\pixmaps\pu2.gif"
  File "lib\pixmaps\po2.gif"
  File "lib\pixmaps\pn.gif"
  File "lib\pixmaps\pm.gif"
  File "lib\pixmaps\pl.gif"
  File "lib\pixmaps\pa.gif"
  File "lib\pixmaps\mv.gif"
  File "lib\pixmaps\mk.gif"
  File "lib\pixmaps\li.gif"
  File "lib\pixmaps\i.gif"
  File "lib\pixmaps\fy.gif"
  File "lib\pixmaps\fx.gif"
  File "lib\pixmaps\fi.gif"
  File "lib\pixmaps\e.gif"
  File "lib\pixmaps\d2.gif"
  File "lib\pixmaps\cw.gif"
  File "lib\pixmaps\cp.gif"
  File "lib\pixmaps\co.gif"
  File "lib\pixmaps\ccw.gif"
  File "lib\pixmaps\bd.gif"
  File "lib\pixmaps\b.gif"
  File "lib\pixmaps\a.gif"
  File "lib\pixmaps\z5.gif"
  File "lib\pixmaps\stip75.xbm"
  File "lib\pixmaps\stip62.xbm"
  File "lib\pixmaps\stip50.xbm"
  File "lib\pixmaps\stip38.xbm"
  File "lib\pixmaps\stip25.xbm"
  File "lib\pixmaps\stip12.xbm"
  File "lib\pixmaps\solid.xbm"
  File "lib\pixmaps\stip88.xbm"
SectionEnd

Section "Tcl/Tk" SEC02
  SetOutPath "$INSTDIR\tcl\bin"
  SetOverwrite try
  File "..\..\..\..\..\Software\Tcl\bin\tcl84.dll"
  File "..\..\..\..\..\Software\Tcl\bin\tclpip84.dll"
  File "..\..\..\..\..\Software\Tcl\bin\tclsh84.exe"
  File "..\..\..\..\..\Software\Tcl\bin\tk84.dll"
  File "..\..\..\..\..\Software\Tcl\bin\wish84.exe"
  SetOutPath "$INSTDIR\tcl\include"
  File "..\..\..\..\..\Software\Tcl\include\tcl.h"
  File "..\..\..\..\..\Software\Tcl\include\tclDecls.h"
  File "..\..\..\..\..\Software\Tcl\include\tclPlatDecls.h"
  File "..\..\..\..\..\Software\Tcl\include\tk.h"
  File "..\..\..\..\..\Software\Tcl\include\tkDecls.h"
  File "..\..\..\..\..\Software\Tcl\include\tkIntXlibDecls.h"
  File "..\..\..\..\..\Software\Tcl\include\tkPlatDecls.h"
  SetOutPath "$INSTDIR\tcl\include\X11"
  File "..\..\..\..\..\Software\Tcl\include\X11\cursorfont.h"
  File "..\..\..\..\..\Software\Tcl\include\X11\keysym.h"
  File "..\..\..\..\..\Software\Tcl\include\X11\keysymdef.h"
  File "..\..\..\..\..\Software\Tcl\include\X11\X.h"
  File "..\..\..\..\..\Software\Tcl\include\X11\Xatom.h"
  File "..\..\..\..\..\Software\Tcl\include\X11\Xfuncproto.h"
  File "..\..\..\..\..\Software\Tcl\include\X11\Xlib.h"
  File "..\..\..\..\..\Software\Tcl\include\X11\Xutil.h"
  SetOutPath "$INSTDIR\tcl\lib\dde1.2"
  File "..\..\..\..\..\Software\Tcl\lib\dde1.2\pkgIndex.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\dde1.2\tcldde12.dll"
  SetOutPath "$INSTDIR\tcl\lib\reg1.1"
  File "..\..\..\..\..\Software\Tcl\lib\reg1.1\pkgIndex.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\reg1.1\tclreg11.dll"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\auto.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4\encoding"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\ascii.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\big5.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1250.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1251.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1252.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1253.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1254.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1255.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1256.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1257.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp1258.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp437.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp737.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp775.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp850.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp852.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp855.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp857.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp860.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp861.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp862.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp863.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp864.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp865.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp866.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp869.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp874.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp932.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp936.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp949.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\cp950.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\dingbats.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\ebcdic.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\euc-cn.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\euc-jp.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\euc-kr.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\gb12345.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\gb1988.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\gb2312-raw.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\gb2312.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso2022-jp.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso2022-kr.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso2022.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-1.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-10.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-13.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-14.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-15.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-16.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-2.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-3.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-4.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-5.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-6.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-7.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-8.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\iso8859-9.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\jis0201.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\jis0208.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\jis0212.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\koi8-r.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\koi8-u.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\ksc5601.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macCentEuro.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macCroatian.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macCyrillic.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macDingbats.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macGreek.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macIceland.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macJapan.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macRoman.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macRomania.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macThai.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macTurkish.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\macUkraine.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\shiftjis.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\symbol.enc"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\encoding\tis-620.enc"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\history.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4\http1.0"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\http1.0\http.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\http1.0\pkgIndex.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4\http2.5"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\http2.5\http.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\http2.5\pkgIndex.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\init.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\ldAout.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4\msgcat1.3"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\msgcat1.3\msgcat.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\msgcat1.3\pkgIndex.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4\opt0.4"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\opt0.4\optparse.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\opt0.4\pkgIndex.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\package.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\parray.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\safe.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\tclIndex"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4\tcltest2.2"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\tcltest2.2\pkgIndex.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\tcltest2.2\tcltest.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tcl8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tcl8.4\word.tcl"
  SetOutPath "$INSTDIR\tcl\lib"
  File "..\..\..\..\..\Software\Tcl\lib\tcl84.lib"
  File "..\..\..\..\..\Software\Tcl\lib\tclstub84.lib"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\bgerror.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\button.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\choosedir.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\clrpick.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\comdlg.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\console.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4\demos"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\arrow.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\bind.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\bitmap.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\browse"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\button.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\check.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\clrpick.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\colors.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\cscroll.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\ctext.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\dialog1.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\dialog2.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\entry1.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\entry2.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\entry3.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\filebox.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\floor.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\form.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\hello"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\hscale.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\icon.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\image1.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\image2.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4\demos\images"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\earth.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\earthris.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\face.bmp"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\flagdown.bmp"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\flagup.bmp"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\gray25.bmp"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\letters.bmp"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\noletter.bmp"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\pattern.bmp"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\tcllogo.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\images\teapot.ppm"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4\demos"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\items.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\ixset"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\label.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\labelframe.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\license.terms"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\menu.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\menubu.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\msgbox.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\paned1.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\paned2.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\plot.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\puzzle.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\radio.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\README"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\rmt"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\rolodex"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\ruler.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\sayings.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\search.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\spin.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\square"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\states.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\style.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\tclIndex"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\tcolor"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\text.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\timer"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\twind.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\unicodeout.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\vscale.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\demos\widget"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\dialog.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\entry.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\focus.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4\images"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\logo.eps"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\logo100.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\logo64.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\logoLarge.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\logoMed.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\pwrdLogo.eps"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\pwrdLogo100.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\pwrdLogo150.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\pwrdLogo175.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\pwrdLogo200.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\pwrdLogo75.gif"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\README"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\images\tai-ku.gif"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\license.terms"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\listbox.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\menu.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\mkpsenc.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgbox.tcl"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4\msgs"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\cs.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\de.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\el.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\en.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\en_gb.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\eo.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\es.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\fr.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\it.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\nl.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\pl.msg"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\msgs\ru.msg"
  SetOutPath "$INSTDIR\tcl\lib\tk8.4"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\obsolete.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\optMenu.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\palette.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\panedwindow.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\pkgIndex.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\safetk.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\scale.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\scrlbar.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\spinbox.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\tclIndex"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\tearoff.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\text.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\tk.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\tkfbox.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\unsupported.tcl"
  File "..\..\..\..\..\Software\Tcl\lib\tk8.4\xmfbox.tcl"
  SetOutPath "$INSTDIR\tcl\lib"
  File "..\..\..\..\..\Software\Tcl\lib\tk84.lib"
  File "..\..\..\..\..\Software\Tcl\lib\tkstub84.lib"
SectionEnd

Var wish_exe_path

Function WishExePage
SectionGetFlags ${SEC02} $R0
IntOp $R0 $R0 & ${SF_SELECTED}
IntCmp $R0 ${SF_SELECTED} 0 show
Abort
show:
!insertmacro MUI_HEADER_TEXT "Tcl/Tk Location" "Enter the location for the wish (Tcl/Tk) executable"
!insertmacro MUI_INSTALLOPTIONS_DISPLAY "wishexe.ini"
FunctionEnd

Function WishExeValidate
ReadIniStr $wish_exe_path "$PLUGINSDIR\wishexe.ini" "Field 2" "State"
IfFileExists $wish_exe_path +3 0
  MessageBox MB_ICONSTOP|MB_OK "The specified location for the wish executable does not exist."
  Abort
FunctionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\bin\xcircuit-win32.exe"
  StrCmp $wish_exe_path "" use_builtin_tcl use_system_tcl
use_builtin_tcl:
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "WishExe" "$INSTDIR\tcl\bin\wish84.exe"
  Goto done
use_system_tcl:
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "WishExe" "$wish_exe_path"
done:
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "LibPath" "$INSTDIR\xcircuit-${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\bin\xcircuit-win32.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "XCircuit Application"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "Tcl/Tk Framework (compiled for Win32 platforms)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\tcl\lib\tkstub84.lib"
  Delete "$INSTDIR\tcl\lib\tk84.lib"
  Delete "$INSTDIR\tcl\lib\tk8.4\xmfbox.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\unsupported.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\tkfbox.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\tk.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\text.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\tearoff.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\tclIndex"
  Delete "$INSTDIR\tcl\lib\tk8.4\spinbox.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\scrlbar.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\scale.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\safetk.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\panedwindow.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\palette.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\optMenu.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\obsolete.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\ru.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\pl.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\nl.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\it.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\fr.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\es.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\eo.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\en_gb.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\en.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\el.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\de.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgs\cs.msg"
  Delete "$INSTDIR\tcl\lib\tk8.4\msgbox.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\mkpsenc.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\menu.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\listbox.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\license.terms"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\tai-ku.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\README"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\pwrdLogo75.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\pwrdLogo200.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\pwrdLogo175.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\pwrdLogo150.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\pwrdLogo100.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\pwrdLogo.eps"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\logoMed.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\logoLarge.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\logo64.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\logo100.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\images\logo.eps"
  Delete "$INSTDIR\tcl\lib\tk8.4\focus.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\entry.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\dialog.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\widget"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\vscale.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\unicodeout.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\twind.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\timer"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\text.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\tcolor"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\tclIndex"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\style.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\states.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\square"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\spin.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\search.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\sayings.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\ruler.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\rolodex"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\rmt"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\README"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\radio.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\puzzle.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\plot.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\paned2.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\paned1.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\msgbox.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\menubu.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\menu.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\license.terms"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\labelframe.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\label.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\ixset"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\items.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\teapot.ppm"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\tcllogo.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\pattern.bmp"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\noletter.bmp"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\letters.bmp"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\gray25.bmp"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\flagup.bmp"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\flagdown.bmp"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\face.bmp"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\earthris.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\images\earth.gif"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\image2.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\image1.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\icon.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\hscale.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\hello"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\form.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\floor.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\filebox.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\entry3.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\entry2.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\entry1.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\dialog2.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\dialog1.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\ctext.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\cscroll.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\colors.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\clrpick.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\check.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\button.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\browse"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\bitmap.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\bind.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\demos\arrow.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\console.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\comdlg.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\clrpick.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\choosedir.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\button.tcl"
  Delete "$INSTDIR\tcl\lib\tk8.4\bgerror.tcl"
  Delete "$INSTDIR\tcl\lib\tclstub84.lib"
  Delete "$INSTDIR\tcl\lib\tcl84.lib"
  Delete "$INSTDIR\tcl\lib\tcl8.4\word.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\tcltest2.2\tcltest.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\tcltest2.2\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\tclIndex"
  Delete "$INSTDIR\tcl\lib\tcl8.4\safe.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\parray.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\package.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\opt0.4\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\opt0.4\optparse.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\msgcat1.3\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\msgcat1.3\msgcat.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\ldAout.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\init.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\http2.5\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\http2.5\http.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\http1.0\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\http1.0\http.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\history.tcl"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\tis-620.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\symbol.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\shiftjis.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macUkraine.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macTurkish.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macThai.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macRomania.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macRoman.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macJapan.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macIceland.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macGreek.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macDingbats.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macCyrillic.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macCroatian.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\macCentEuro.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\ksc5601.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\koi8-u.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\koi8-r.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\jis0212.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\jis0208.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\jis0201.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-9.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-8.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-7.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-6.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-5.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-4.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-3.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-2.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-16.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-15.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-14.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-13.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-10.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso8859-1.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso2022.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso2022-kr.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\iso2022-jp.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\gb2312.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\gb2312-raw.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\gb1988.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\gb12345.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\euc-kr.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\euc-jp.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\euc-cn.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\ebcdic.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\dingbats.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp950.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp949.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp936.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp932.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp874.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp869.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp866.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp865.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp864.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp863.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp862.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp861.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp860.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp857.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp855.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp852.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp850.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp775.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp737.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp437.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1258.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1257.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1256.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1255.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1254.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1253.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1252.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1251.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\cp1250.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\big5.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\encoding\ascii.enc"
  Delete "$INSTDIR\tcl\lib\tcl8.4\auto.tcl"
  Delete "$INSTDIR\tcl\lib\reg1.1\tclreg11.dll"
  Delete "$INSTDIR\tcl\lib\reg1.1\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\lib\dde1.2\tcldde12.dll"
  Delete "$INSTDIR\tcl\lib\dde1.2\pkgIndex.tcl"
  Delete "$INSTDIR\tcl\include\X11\Xutil.h"
  Delete "$INSTDIR\tcl\include\X11\Xlib.h"
  Delete "$INSTDIR\tcl\include\X11\Xfuncproto.h"
  Delete "$INSTDIR\tcl\include\X11\Xatom.h"
  Delete "$INSTDIR\tcl\include\X11\X.h"
  Delete "$INSTDIR\tcl\include\X11\keysymdef.h"
  Delete "$INSTDIR\tcl\include\X11\keysym.h"
  Delete "$INSTDIR\tcl\include\X11\cursorfont.h"
  Delete "$INSTDIR\tcl\include\tkPlatDecls.h"
  Delete "$INSTDIR\tcl\include\tkIntXlibDecls.h"
  Delete "$INSTDIR\tcl\include\tkDecls.h"
  Delete "$INSTDIR\tcl\include\tk.h"
  Delete "$INSTDIR\tcl\include\tclPlatDecls.h"
  Delete "$INSTDIR\tcl\include\tclDecls.h"
  Delete "$INSTDIR\tcl\include\tcl.h"
  Delete "$INSTDIR\tcl\bin\wish84.exe"
  Delete "$INSTDIR\tcl\bin\tk84.dll"
  Delete "$INSTDIR\tcl\bin\tclsh84.exe"
  Delete "$INSTDIR\tcl\bin\tclpip84.dll"
  Delete "$INSTDIR\tcl\bin\tcl84.dll"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\stip88.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\solid.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\stip12.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\stip25.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\stip38.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\stip50.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\stip62.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\stip75.xbm"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\z5.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\a.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\b.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\bd.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\ccw.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\co.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\cp.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\cw.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\d2.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\e.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\fi.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\fx.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\fy.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\i.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\li.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\mk.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\mv.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\pa.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\pl.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\pm.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\pn.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\po2.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\pu2.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\pz.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\q.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\s.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\t.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\tg.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\ti.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\tp.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\uj.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\w.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\xcircuit.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\yp.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps\z4.gif"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\courier.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\courier.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\courieriso2.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\courieriso2.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\courieriso5.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\courieriso5.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\courieriso.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\helvetica.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\helvetica.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\helveticaiso2.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\helveticaiso2.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\helveticaiso5.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\helveticaiso5.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\helveticaiso.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\myfont.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\myfont.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\symbol.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\symbol.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\times_roman.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\times_roman.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\times_romaniso2.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\times_romaniso2.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\times_romaniso5.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\times_romaniso5.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts\times_romaniso.xfe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\xcircps2.pro"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\xspice.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\analog.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\analoglib2.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\analoglib3.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\asg_spice.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\avlsi.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\digital.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\generic.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\ic_templates.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\lgf.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\musiclib.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pcb.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pcb_layout.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\quadparts.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\series74xx.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\signal.lps"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\xcircexec.exe"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\xcircuit.dll"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\xcstartup.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\panzoom.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pcbout.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\resource.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\sue_xc.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\tkcon.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\wrapper.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\xcircuit.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\ngspice.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\library.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\console.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\bparams.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\autoincr.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\files.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\mousehint.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\symbol.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\sinusoid.tcl"
  Delete "$INSTDIR\xcircuit-${PRODUCT_VERSION}\xchelp.tcl"
  Delete "$INSTDIR\bin\xcircuit.bat"
  Delete "$INSTDIR\bin\xcircuit-win32.exe"

  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Website.lnk"
  Delete "$DESKTOP\${PRODUCT_NAME}.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\XCircuit.lnk"

  RMDir "$SMPROGRAMS\${PRODUCT_NAME}"
  RMDir "$INSTDIR\xcircuit-${PRODUCT_VERSION}\pixmaps"
  RMDir "$INSTDIR\xcircuit-${PRODUCT_VERSION}\fonts"
  RMDir "$INSTDIR\xcircuit-${PRODUCT_VERSION}"
  RMDir "$INSTDIR\tcl\lib\tk8.4\msgs"
  RMDir "$INSTDIR\tcl\lib\tk8.4\images"
  RMDir "$INSTDIR\tcl\lib\tk8.4\demos\images"
  RMDir "$INSTDIR\tcl\lib\tk8.4\demos"
  RMDir "$INSTDIR\tcl\lib\tk8.4"
  RMDir "$INSTDIR\tcl\lib\tcl8.4\tcltest2.2"
  RMDir "$INSTDIR\tcl\lib\tcl8.4\opt0.4"
  RMDir "$INSTDIR\tcl\lib\tcl8.4\msgcat1.3"
  RMDir "$INSTDIR\tcl\lib\tcl8.4\http2.5"
  RMDir "$INSTDIR\tcl\lib\tcl8.4\http1.0"
  RMDir "$INSTDIR\tcl\lib\tcl8.4\encoding"
  RMDir "$INSTDIR\tcl\lib\tcl8.4"
  RMDir "$INSTDIR\tcl\lib\reg1.1"
  RMDir "$INSTDIR\tcl\lib\dde1.2"
  RMDir "$INSTDIR\tcl\lib"
  RMDir "$INSTDIR\tcl\include\X11"
  RMDir "$INSTDIR\tcl\include"
  RMDir "$INSTDIR\tcl\bin"
  RMDir "$INSTDIR\tcl"
  RMDir "$INSTDIR\bin"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
