#include "write.h"

static int wri_can_write(char *path){
	int fd, len=strlen(path)+strlen(_PATH_DEV)+1;
	char *totalpath=(char*)malloc(sizeof(char)*len);
	
	strncpy(totalpath, _PATH_DEV, strlen(_PATH_DEV)+1);
	strncat(totalpath, path, strlen(path)+1);
	fd=open(totalpath, O_WRONLY);
	if(fd<0) {
		perror(totalpath);
		return 0;
	}
	else return isatty(fd);
}

int wri_do_write(char *user, char *line, char *message){
	int cmdlen=(strlen("write ")+strlen(user)+1+strlen(line)+1);
	char *cmd=(char*)malloc(sizeof(char)*cmdlen);
	FILE *dest;
	
	printf("can i write to %s?", line);
	if(!wri_can_write(line)) {
		fprintf(stderr, "%s: warning, not writing to %s on %s\n",
				g_config.progname, user, line);
		return -1;
	}
	snprintf(cmd, cmdlen, "write %s %s", user, line);
	dest=popen(cmd, "w");
	fprintf(dest, "%s", message);
	if(!g_config.no_newline)fprintf(dest, "\n");

	pclose(dest);
	return 0;
}
