'\"
'\" Generated from file 'canvas_epolyline\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "canvas::edit::polyline" n 0\&.2 tklib "Variations on a canvas"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
canvas::edit::polyline \- Editing a polyline on a canvas
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTk  8\&.5\fR
.sp
package require \fBcanvas::edit::points  ?0\&.1?\fR
.sp
package require \fBcanvas::edit::polyline  ?0\&.2?\fR
.sp
\fB::canvas::edit\fR \fBpolyline\fR \fIobjectName\fR \fIcanvas\fR \fIoptions\fR\&.\&.\&.
.sp
\fBobjectName\fR \fBdestroy\fR
.sp
\fBobjectName\fR \fBenable\fR
.sp
\fBobjectName\fR \fBdisable\fR
.sp
\fBobjectName\fR \fBactive\fR
.sp
\fBobjectName\fR \fBadd\fR \fIx\fR \fIy\fR
.sp
\fBobjectName\fR \fBclear\fR
.sp
\fBactiveCmd\fR \fIeditorObj\fR \fIid\fR
.sp
\fBcreateCmd\fR \fIcanvas\fR \fIx\fR \fIy\fR
.sp
\fBdataCmd\fR \fIeditorObj\fR \fIcoordinates\fR
.sp
.BE
.SH DESCRIPTION
This package provides a class whose instances handle editing a single poly-line (or -gon) on a
canvas\&. Instances can be configured with regard to the visual appearance of the markers denoting the
line's vertices, as well as if the line is to be closed or not, and further if a closed line has to
be convex or not\&. Note that instances do not store the edited polyline themselves, but delegate this
to a configurable object\&.
.SH INTERACTION
.PP
The polyline editor internally uses an instance of package \fBcanvas::edit::points\fR,
and inherits all the options and behaviours for it\&. The color options are additionally applied to
the line element of this editor
.PP
Beyond that it provides 2 options to configure the editing mode, and one option to customize
the line/polygon item used to render the line through the points\&.
.PP
The main editing mode is controlled by option \fB-closed\fR for \fIline\fR (i\&.e\&. open)
versus \fIpolygon\fR (i\&.e\&. closed)\&. The default is line/open mode\&.
.PP
In polygon/closed mode the option \fB-convex\fR controls if the editor enforces convexity
of the polygon, or not\&. The default is no enforcement of convexity\&.
.PP
The option \fB-line-config\fR enables basic customization of the line/polygon item\&. Note
that it cannot overide the inherited color options\&.
.SH "CLASS API"
.TP
\fB::canvas::edit\fR \fBpolyline\fR \fIobjectName\fR \fIcanvas\fR \fIoptions\fR\&.\&.\&.
This, the class command, creates and configures a new instance of a
polyline editor, named \fIobjectName\fR\&. The instance will be
connected to the specified \fIcanvas\fR widget\&.
.sp
The result of the command is the fully qualified name of the
instance command\&.
.sp
The options accepted here, and their values, are explained in
the section \fBOptions\fR\&.
.PP
.SH "INSTANCE API"
Instances of the polyline editors provide the following API:
.TP
\fBobjectName\fR \fBdestroy\fR
This method destroys the polyline editor and releases all its
internal resources\&.
.sp
Note that this operation does not destroy the items the editor
managed on the attached canvas, nor the canvas itself\&.
.sp
The result of the method is an empty string\&.
.TP
\fBobjectName\fR \fBenable\fR
This method activates editing of the polyline on the canvas\&. This
is the default after instance creation\&. A call is ignored if the
editor is already active\&.
.sp
The result of the method is an empty string\&.
.sp
The complementary method is \fBdisable\fR\&. The interogatory
method for the current state is \fBactive\fR\&.
.TP
\fBobjectName\fR \fBdisable\fR
This method disables editing of the polyline on the canvas\&. A call
is ignored if the editor is already disabled\&.
.sp
The result of the method is an empty string\&.
.sp
The complementary method is \fBenable\fR\&. The interogatory
method for the current state is \fBactive\fR\&.
.TP
\fBobjectName\fR \fBactive\fR
This method queries the editor state\&.
.sp
The result of the method is a boolean value, \fBtrue\fR if
the editor is active, and \fBfalse\fR otherwise, i\&.e\&. disabled\&.
.sp
The methods to change the state are \fBenable\fR and
\fBdisable\fR\&.
.TP
\fBobjectName\fR \fBadd\fR \fIx\fR \fIy\fR
This method programmatically adds a vertex at the specified location to the line\&.
.sp
The result of the method is an empty string\&.
.sp
Note that this method goes through the whole set of callbacks
invoked when the user interactively creates a vertex, i\&.e\&.
\fB-create-cmd\fR, and, more importantly, \fB-data-cmd\fR\&.
.sp
One important difference however\&. The new vertex is always added
at the end of the line, whereas interactive creation uses heuristics
to splice it into the line at a suitable location\&.
.sp
This is the method through which to load the vertices of a
pre-existing line into an editor instance\&.
.TP
\fBobjectName\fR \fBclear\fR
This method programmatically removes all vertices from the editor,
essentially removing the whole line\&.
.sp
The result of the method is an empty string\&.
.sp
Note that this method goes through the same callbacks invoked
when the user interactively removes a vertex, i\&.e\&. \fB-data-cmd\fR\&.
.PP
.SH OPTIONS
The class command accepts the following options
.TP
\fB-active-cmd\fR \fIcommand-prefix\fR
The value of this option is a command prefix the editor will invoke
when the mouse enters or leaves the line or a point managed by the instance\&.
.sp
If not specified it defaults to an empty command which does nothing\&.
.sp
The signature of this command prefix is
.RS
.TP
\fBactiveCmd\fR \fIeditorObj\fR \fIid\fR
.sp
The \fIid\fR identifies the entered object\&.
.sp
An empty \fIid\fR indicates that the last entered object was left\&.
.sp
The value \fBline\fR indicates that the line was entered\&.
.sp
A numeric value \fBN\fR indicates that the \fBN\fR'th vertex of the line was entered,
counting from \fB0\fR\&.
.sp
The result of this method is ignored\&.
.RE
.TP
\fB-add-remove-point\fR \fIeventspec\fR
The value of this option is an event specification (without bracketing angles) declaring which event
will trigger adding and removing a point\&.
.sp
This option can only be set at construction time\&.
.sp
The default setup uses different events for adding and removing points, \fBButtonPress-1\fR
and \fBButtonPress-2\fR respectively\&.
.sp
When using this option the same event is used for both operations\&. This is no problem because
adding is bound as canvas-global event while removal is bound to the relevant canvas items\&.
.TP
\fB-closed\fR \fIboolean\fR
The value of this option is a boolean flag indicating if the edited polyline is closed, i\&.e\&. a loop,
or not\&. \fINOTE\fR that a proper loop requires at least 3 points\&. For less than that an open line
is shown, or even just a point\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to \fBfalse\fR
.TP
\fB-color\fR \fIcolorspec\fR
The value of this option is the fill color for the default item created when adding a point, and no
\fB-create-cmd\fR is specified\&.
.sp
The default value is \fBSkyBlue2\fR\&.
.TP
\fB-convex\fR \fIboolean\fR
The value of this option is a boolean flag indicating if the edited polyline is strictly convex, or
not\&.
This option has meaning if and only if option \fB-closed\fR is configured to be \fBtrue\fR\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to \fBfalse\fR
.TP
\fB-create-cmd\fR \fIcommand-prefix\fR
The value of this option is a command prefix the editor will invoke
when it has to create a new vertex\&.
.sp
While this option can be set after construction, it is recommended to use this feature only
as a means of inserting custom processing to be done at creation time which remembers and calls the
previous value of the option\&.
.sp
If not specified it defaults to a command which will create a
black-bordered blue circle of radius 3 centered on the location of the
new point\&.
.sp
The signature of this command prefix is
.RS
.TP
\fBcreateCmd\fR \fIcanvas\fR \fIx\fR \fIy\fR
The result of the command prefix \fImust\fR be a list of the canvas
items it created to represent the marker\&. Note here that the visual
representation of a "vertex" may consist of multiple canvas items in
an arbitrary shape\&.
.sp
The returned list of items is allowed to be empty, and such is
taken as signal that the callback vetoed the creation of the vertex\&.
.RE
.TP
\fB-data-cmd\fR \fIcommand-prefix\fR
The value of this option is a command prefix the editor will invoke
when the line was edited in some way (vertex added, removed,
moved)\&. This is how the editor delegates the actual storage of the
line information to an outside object\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to an empty string and is ignored
by the editor, i\&.e\&. not invoked\&.
.sp
The signature of this command prefix is
.RS
.TP
\fBdataCmd\fR \fIeditorObj\fR \fIcoordinates\fR
This callback is invoked when the line was changed either interactively,
or programmatically\&.
See instance method \fBadd\fR for the latter\&.
.sp
The \fIeditorObj\fR identifies the instance invoking the
callback, whereas \fIcoordinates\fR is a list of vertex locations,
with each location a pair of x- and y-coordinates\&.
.sp
The result of this method is ignored\&.
.RE
.TP
\fB-drag-point\fR \fIeventspec\fR
The value of this option is an event specification (without bracketing angles) declaring which event
will trigger a drag action on points\&.
.sp
This option can only be set at construction time\&.
.sp
The default specification is \fBButtonPress-3\fR\&.
.TP
\fB-hilit-color\fR \fIcolorspec\fR
The value of this option is the highlight color for the default item created when adding a point,
and no \fB-highlight-cmd\fR is specified\&.
.sp
The default value is \fBred\fR\&.
.TP
\fB-kind\fR \fIname\fR
The value of this option is the canvas item type for the default item created when adding a point,
and no \fB-create-cmd\fR is specified\&.
Only item types specified through a bounding box are suitable\&.
.sp
The default value is \fBoval\fR\&.
.TP
\fB-line-config\fR \fIlist\fR
The value of this option is a list of options and their values to be applied to the internal
line/polygon item whenever it is regenerated after changes\&.
Note that these options \fIcannot\fR override the principal coloring of the line/polygon as
applied by the main options \fB-color\fR and \fB-hilit-color\fR\&.
.sp
If not specified it defaults to the empty list\&.
.TP
\fB-radius\fR \fIint\fR
The value of this option is the radius for the default item created when adding a point,
and no \fB-create-cmd\fR is specified\&.
.sp
The default value is \fB3\fR\&.
.TP
\fB-tag\fR \fIstring\fR
The value of this option is the name of the canvas tag with which to
identify all items of all vertices managed by the editor\&.
.sp
This option can only be set at construction time\&.
.sp
If not specified it defaults to \fBPOLYLINE\fR
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIcanvas\fR of the
\fITklib Trackers\fR [http://core\&.tcl\&.tk/tklib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
canvas, editing, polyline
