#pragma once

#include <tango/tango.h>

namespace FileDb
{

using Tango::string_dup;

template <typename CharT, typename Traits>
inline char *string_dup(const std::basic_string<CharT, Traits> &s)
{
    return CORBA::string_dup(s.c_str());
}

template <typename CharT, typename Traits>
inline char *string_dup(const std::basic_string_view<CharT, Traits> &s)
{
    char *result = CORBA::string_alloc(s.size() + 1);
    if(result != nullptr)
    {
        memcpy(result, s.data(), s.size());
        result[s.size()] = '\0';
    }
    return result;
}

} // namespace FileDb
