# 2025-03-31 Triage Log

Positive week, with a lot of primary improvements and just a few secondary regressions. Single big regression got reverted.

Triage done by **@panstromek**.
Revision range: [4510e86a..2ea33b59](https://perf.rust-lang.org/?start=4510e86a41388733675465a8647d4235f3bf2023&end=2ea33b591050c4ca1a3752830b29112638faecf6&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 1.5%]   | 17    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-4.5%, -0.1%] | 136   |
| Improvements ✅ <br /> (secondary) | -0.6% | [-3.2%, -0.1%] | 59    |
| All ❌✅ (primary)                 | -0.4% | [-4.5%, -0.1%] | 136   |


1 Regression, 6 Improvements, 4 Mixed; 3 of them in rollups
39 artifact comparisons made in total

#### Regressions

perform less decoding if it has the same syntax context [#129827](https://github.com/rust-lang/rust/pull/129827) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5cc60728e7ee10eb2ae5f61f7d412d9805b22f0c&end=d4812c8638173ec163825d56a72a33589483ec4c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.1%, 3.8%]   | 77    |
| Regressions ❌ <br /> (secondary)  | 2.3%  | [0.2%, 6.1%]   | 37    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.9%  | [0.1%, 3.8%]   | 77    |

Reverted in #[139130](https://github.com/rust-lang/rust/pull/139130).

#### Improvements

rustdoc: Rearrange `Item`/`ItemInner`. [#138927](https://github.com/rust-lang/rust/pull/138927) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ecb170afc878648c3ae355dbd596c8e4b6f7ebdc&end=217693a1f02ca6431a434926ff3417bdb6dbac2e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.3%] | 2     |


Rollup of 7 pull requests [#139023](https://github.com/rust-lang/rust/pull/139023) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=217693a1f02ca6431a434926ff3417bdb6dbac2e&end=3f5502370b8f60e4df98deba4c22ea26f4f6be55&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.2%] | 21    |


Avoid wrapping constant allocations in packed structs when not necessary [#138503](https://github.com/rust-lang/rust/pull/138503) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e77a8f439cc87c5d67b007e9811578533de1de91&end=2a06022951893fe5b5384f8dbd75b4e6e3b5cee0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.6% | [-4.9%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -2.0% | [-3.3%, -0.3%] | 9     |
| All ❌✅ (primary)                 | -1.6% | [-4.9%, -0.3%] | 6     |


Rollup of 7 pull requests [#139054](https://github.com/rust-lang/rust/pull/139054) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2a06022951893fe5b5384f8dbd75b4e6e3b5cee0&end=19f42cb9bb65555e7d95dab7d17573ae6c5d634c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-2.2%, -0.1%] | 9     |
| All ❌✅ (primary)                 | -     | -              | 0     |


Remove `terminating_scopes` hash set. [#139067](https://github.com/rust-lang/rust/pull/139067) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=928468c47c2a670bfa62727cfa2f14f75f5b7331&end=898916595c4496cee237a82f3f07650e5bd70447&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.2%, -0.1%] | 9     |
| All ❌✅ (primary)                 | -0.1% | [-0.1%, -0.1%] | 1     |


Revert "Auto merge of #129827 - bvanjoi:less-decoding, r=petrochenkov" [#139130](https://github.com/rust-lang/rust/pull/139130) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b9ea82b84ad02b4a9fe9e513626e65fb3f540838&end=45b40a75966b36d3588f173441896fddad01cd80&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.4%, 0.6%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-3.6%, -0.1%] | 74    |
| Improvements ✅ <br /> (secondary) | -2.2% | [-5.7%, -0.2%] | 37    |
| All ❌✅ (primary)                 | -0.9% | [-3.6%, -0.1%] | 74    |

Addresses the regression above.

#### Mixed

Rollup of 9 pull requests [#138923](https://github.com/rust-lang/rust/pull/138923) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7d49ae9731555937177d01e9fa39dbf22eb60399&end=48994b1674b3212d27b5e83841c0966bc2b4be43&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 1.4%]   | 14    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.6%, -0.6%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -0.6% | [-0.6%, -0.6%] | 1     |

Regressions for `unused-warnings`, seems to be somewhere in the frontend (check build regressed the most).

Seems like it's [#138580](https://github.com/rust-lang/rust/pull/138580).

Quoting [comment from the author](https://github.com/rust-lang/rust/pull/138580#issuecomment-2729429154)

> Probably fine, unused-warnings is a stress test for single_imports.

Part of it is probably continuation of that PR in [#138837](https://github.com/rust-lang/rust/pull/138837)


hygiene: Ensure uniqueness of `SyntaxContextData`s [#130324](https://github.com/rust-lang/rust/pull/130324) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f1bc669636023c8643602431791c7f26e5a6edef&end=19cab6b878ab18dce4816d85ac52b317214c485f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.2%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 30    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 3     |
| All ❌✅ (primary)                 | -0.4% | [-0.7%, -0.2%] | 30    |

Improvements outweigh regressions. Regression `tt-muncher` seems spurious (the benchmark got back to previous state in a following rollup). `deep-vector` looks like noise. 


Remove `prev_index_to_index` field from `CurrentDepGraph` [#138824](https://github.com/rust-lang/rust/pull/138824) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=19cab6b878ab18dce4816d85ac52b317214c485f&end=a2e63569fd6702ac5dd027a80a9fdaadce73adae&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.4%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 30    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 30    |

Instruction count improvements outweigh regressions. Regression in `unused-warnings` looks real, but small.

There's a somewhat large `max-rss` and `wall-time` regression in small incremental scenarios.


Simplify expansion for format_args!(). [#139131](https://github.com/rust-lang/rust/pull/139131) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fedf10752b973d83f3f7c0f819b2659c21a634de&end=2ea33b591050c4ca1a3752830b29112638faecf6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | -0.5% | [-0.8%, -0.2%] | 8     |

[Pre-merge results](https://github.com/rust-lang/rust/pull/139131#issuecomment-2764550579) look better than post-merge. Single regression in `tt-muncher` looks like noise.
