# 2024-04-23 Triage Log

A week dominated by small mixed changes to perf with improvements slightly outweighing regressions. There were no pure regressions, and many of the mixed perf results were deemed worth it for their potential improvements to runtime performance through further optimization from LLVM.

Triage done by **@rylev**.
Revision range: [ccfcd950..a77f76e2](https://perf.rust-lang.org/?start=ccfcd950b333fed046275dd8d54fe736ca498aa7&end=a77f76e26302e9a084fb321817675b1dfc1dcd63&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.8%]   | 57    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 1.9%]   | 26    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-3.4%, -0.2%] | 50    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.9%, -0.1%] | 32    |
| All ❌✅ (primary)                 | -0.2% | [-3.4%, 1.8%]  | 107   |


0 Regressions, 5 Improvements, 6 Mixed; 2 of them in rollups
62 artifact comparisons made in total

#### Regressions



#### Improvements

Simplify shallow resolver to just fold ty/consts [#123537](https://github.com/rust-lang/rust/pull/123537) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1cec373f65eb76e8e4b4d1847213cf3ec6c292b6&end=3fba2782310b2754259a3c329220a5b1e6cf9a5c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.4%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 11    |
| All ❌✅ (primary)                 | -0.8% | [-1.4%, 0.3%]  | 9     |


rustdoc-search: single result for items with multiple paths [#119912](https://github.com/rust-lang/rust/pull/119912) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3412f0174934778dd803081dc7c4b5864309350f&end=e3181b091e88321f5ea149afed6db0edf0a4f37b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 3     |


interpret: use ScalarInt for bin-ops; avoid PartialOrd for ScalarInt [#124113](https://github.com/rust-lang/rust/pull/124113) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d1a0fa5ed3ffe52d72f761d3c95cbeb0a9cdfe66&end=ce3263e60e73f4018592cbfba540cf8bef4399de&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 4     |


PatRangeBoundary::compare_with: als add a fast-path for signed integers [#124190](https://github.com/rust-lang/rust/pull/124190) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=584f183dc0e0ce8d981811ebbf67886c0cfef9e0&end=c3ceb00281f9557dcf5bba54fc44c9931cc90d42&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -3.3% | [-3.3%, -3.3%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |


Rollup of 7 pull requests [#124271](https://github.com/rust-lang/rust/pull/124271) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=25087e02b34775520856b6cc15e50f5ed0c35f50&end=9cf10bcf5b368de79abc24fc4d50a9d85b377ffa&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.5%, 0.5%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-2.1%, -0.4%] | 9     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |


#### Mixed

Implement syntax for `impl Trait` to specify its captures explicitly (`feature(precise_capturing)`) [#123468](https://github.com/rust-lang/rust/pull/123468) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ad18fe08de03fbb459c05475bddee22707b4f0ec&end=4e1f5d90bca45207605a88e39b1f76abcdb85d2f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 4     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.8%, -0.8%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 4     |
- Very small regression on a stress test


At debuginfo=0, don't inline debuginfo when inlining [#123949](https://github.com/rust-lang/rust/pull/123949) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0e15f5ee8fb3f9edcb8a35b1cbd9f8d352be54a0&end=3412f0174934778dd803081dc7c4b5864309350f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.3%, 1.8%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.2%, 3.4%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-2.4%, -0.1%] | 22    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.8%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -0.6% | [-2.4%, 1.8%]  | 27    |
- Improvements outweighed the regressions and was deemed worth it by the reviewer.


Always display stability version even if it's the same as the containing item [#118441](https://github.com/rust-lang/rust/pull/118441) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=07d0d7ce3fd22e4fadd61206034af6fadcdb3e4f&end=d1a0fa5ed3ffe52d72f761d3c95cbeb0a9cdfe66&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.2%, 0.3%]  | 3     |
- Noise that is reversed in the next run.


Tell LLVM Vec::len is invariant across growth [#123930](https://github.com/rust-lang/rust/pull/123930) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=426a698606ca94d4c4a674a346c701bf44b0aeb3&end=13eb8c736ce58a794434ee316cb86f1091f66c7e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.1%, 1.6%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 11    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.9%, -0.4%] | 8     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.1%] | 3     |
| All ❌✅ (primary)                 | -0.1% | [-0.9%, 1.6%]  | 15    |
-  The regressions come from LLVM, and it was deemed worth it given the possibility for LLVM to perform more optimization.


fix normalizing in different `ParamEnv`s with the same `InferCtxt` [#124203](https://github.com/rust-lang/rust/pull/124203) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f22a0c2d9f9cd83dfe84b65e9fa1b3fa8303c7b5&end=1b3fba066c21e7c3471fca710783fc1e6546a1ca&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 4.1%  | [4.1%, 4.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.4%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-0.9%, -0.9%] | 1     |
| All ❌✅ (primary)                 | -0.7% | [-2.4%, -0.2%] | 9     |
- Noise


Rollup of 5 pull requests [#124241](https://github.com/rust-lang/rust/pull/124241) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1b3fba066c21e7c3471fca710783fc1e6546a1ca&end=fb898629a26e4acec59c928ce3ec00a62675d1cc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.2%, 1.6%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-2.8%, -0.3%] | 7     |
| Improvements ✅ <br /> (secondary) | -3.9% | [-3.9%, -3.9%] | 1     |
| All ❌✅ (primary)                 | -0.1% | [-2.8%, 1.6%]  | 14    |
- More time spent in LLVM previously
- Pinged the author and reviewer for their perspective.