Static variables with the `#[linkage]` attribute within external blocks
must have one of the following types, which are equivalent to a nullable
pointer in C:

* `*mut T` or `*const T`, where `T` may be any type.

* An enumerator type with no `#[repr]` attribute and with two variants, where
  one of the variants has no fields, and the other has a single field of one of
  the following non-nullable types:
  * Reference type
  * Function pointer type

  The variants can appear in either order.

For example, the following declaration is invalid:

```compile_fail,E0791
#![feature(linkage)]

extern "C" {
    #[linkage = "extern_weak"]
    static foo: i8;
}
```

The following declarations are valid:

```
#![feature(linkage)]

extern "C" {
    #[linkage = "extern_weak"]
    static foo: Option<unsafe extern "C" fn()>;

    #[linkage = "extern_weak"]
    static bar: Option<&'static i8>;

    #[linkage = "extern_weak"]
    static baz: *mut i8;
}
```
