# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterWorkspaceSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_settings_list(self, resource_group):
        response = self.client.workspace_settings.list(
            api_version="2017-08-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_settings_get(self, resource_group):
        response = await self.client.workspace_settings.get(
            workspace_setting_name="str",
            api_version="2017-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_settings_create(self, resource_group):
        response = await self.client.workspace_settings.create(
            workspace_setting_name="str",
            workspace_setting={"id": "str", "name": "str", "scope": "str", "type": "str", "workspaceId": "str"},
            api_version="2017-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_settings_update(self, resource_group):
        response = await self.client.workspace_settings.update(
            workspace_setting_name="str",
            workspace_setting={"id": "str", "name": "str", "scope": "str", "type": "str", "workspaceId": "str"},
            api_version="2017-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workspace_settings_delete(self, resource_group):
        response = await self.client.workspace_settings.delete(
            workspace_setting_name="str",
            api_version="2017-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...
