# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from devtools_testutils import recorded_by_proxy
from testpreparer import AIProjectClientTestBase, AIProjectPreparer


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAIProjectEvaluationsOperations(AIProjectClientTestBase):
    @AIProjectPreparer()
    @recorded_by_proxy
    def test_evaluations_get(self, aiproject_endpoint):
        client = self.create_client(endpoint=aiproject_endpoint)
        response = client.evaluations.get(
            name="str",
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy
    def test_evaluations_list(self, aiproject_endpoint):
        client = self.create_client(endpoint=aiproject_endpoint)
        response = client.evaluations.list()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy
    def test_evaluations_create(self, aiproject_endpoint):
        client = self.create_client(endpoint=aiproject_endpoint)
        response = client.evaluations.create(
            evaluation={
                "data": "input_data",
                "evaluators": {"str": {"id": "str", "dataMapping": {"str": "str"}, "initParams": {"str": {}}}},
                "id": "str",
                "description": "str",
                "displayName": "str",
                "properties": {"str": "str"},
                "status": "str",
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy
    def test_evaluations_create_agent_evaluation(self, aiproject_endpoint):
        client = self.create_client(endpoint=aiproject_endpoint)
        response = client.evaluations.create_agent_evaluation(
            evaluation={
                "appInsightsConnectionString": "str",
                "evaluators": {"str": {"id": "str", "dataMapping": {"str": "str"}, "initParams": {"str": {}}}},
                "runId": "str",
                "redactionConfiguration": {"redactScoreProperties": bool},
                "samplingConfiguration": {"maxRequestRate": 0.0, "name": "str", "samplingPercent": 0.0},
                "threadId": "str",
            },
        )

        # please add some check logic here by yourself
        # ...
