from setuptools import setup

setup(
    name="pytest-forked",
    use_scm_version=True,
    description='run tests in isolated forked subprocesses',
    long_description=open('README.rst').read(),
    long_description_content_type='text/x-rst',
    license='MIT',
    author='pytest-dev',
    author_email='pytest-dev@python.org',
    url='https://github.com/pytest-dev/pytest-forked',
    platforms=['linux', 'osx'],
    packages=['pytest_forked'],
    package_dir={'': 'src'},
    entry_points={
        'pytest11': [
            'pytest_forked = pytest_forked',
        ],
    },
    zip_safe=False,
    install_requires=['py', 'pytest>=3.10'],
    setup_requires=['setuptools_scm'],
    python_requires='>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*',
    classifiers=[
        'Development Status :: 7 - Inactive',
        'Framework :: Pytest',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: POSIX',
        'Operating System :: MacOS :: MacOS X',
        'Topic :: Software Development :: Testing',
        'Topic :: Software Development :: Quality Assurance',
        'Topic :: Utilities',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
)
