<?php
/**
 * Horde_ActiveSync_Message_Folder::
 *
 * Portions of this class were ported from the Z-Push project:
 *   File      :   wbxml.php
 *   Project   :   Z-Push
 *   Descr     :   WBXML mapping file
 *
 *   Created   :   01.10.2007
 *
 *   � Zarafa Deutschland GmbH, www.zarafaserver.de
 *   This file is distributed under GPL-2.0.
 *   Consult COPYING file for details
 *
 * @license   http://www.horde.org/licenses/gpl GPLv2
 *
 * @copyright 2009-2020 Horde LLC (http://www.horde.org)
 * @author    Michael J Rubinsky <mrubinsk@horde.org>
 * @package   ActiveSync
 */
/**
 * Horde_ActiveSync_Message_Folder::
 *
 * @license   http://www.horde.org/licenses/gpl GPLv2
 *
 * @copyright 2009-2020 Horde LLC (http://www.horde.org)
 * @author    Michael J Rubinsky <mrubinsk@horde.org>
 * @package   ActiveSync
 *
 * @property string   $parentid      Identifier of parent folder, if applicable.
 * @property string   $_serverid     The private backend server id.
 * @property string   $serverid      Identifier of folder on the backend.
 * @property string   $displayname   Display name for folder.
 * @property integer  $type          Foldertype (Horde_Activesync:: constant).
 */
class Horde_ActiveSync_Message_Folder extends Horde_ActiveSync_Message_Base
{
    /**
     * Id of the parent folder
     *
     * @var string
     */
    public $parentid = false;

    /**
     * Property mapping.
     *
     * @var array
     */
    protected $_mapping = array (
        Horde_ActiveSync::FOLDERHIERARCHY_SERVERENTRYID => array (self::KEY_ATTRIBUTE => 'serverid'),
        Horde_ActiveSync::FOLDERHIERARCHY_PARENTID      => array (self::KEY_ATTRIBUTE => 'parentid'),
        Horde_ActiveSync::FOLDERHIERARCHY_DISPLAYNAME   => array (self::KEY_ATTRIBUTE => 'displayname'),
        Horde_ActiveSync::FOLDERHIERARCHY_TYPE          => array (self::KEY_ATTRIBUTE => 'type')
    );

    /**
     * Property values.
     *
     * @var array
     */
    protected $_properties = array(
        'serverid'    => false,
        '_serverid'   => false,
        '_parentid'   => false,
        'displayname' => false,
        'type'        => false,
    );

    /**
     * Get message type.
     *
     * @return string
     */
    public function getClass()
    {
        return 'Folders';
    }

}
