<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Examples

> Commands for running examples.

<!-- Section to include introductory text. Make sure to keep an empty line after the intro `section` element and another before the `/section` close. -->

<section class="intro">

This directory contains [`make`][make] rules for running project examples.

</section>

<!-- /.intro -->

<!-- Usage documentation. -->

<section class="usage">

## Usage

```text
Usage: make <command> [<ENV_VAR>=<value> <ENV_VAR>=<value> ...]
```

### Commands

#### examples

Runs examples.

<!-- run-disable -->

```bash
$ make examples
```

The command supports the following environment variables:

-   **EXAMPLES_FILTER**: file path pattern; e.g., `.*/blas/base/dasum/.*`.

This command is an **alias** for `examples-javascript`, which is documented below.

#### examples-lang

Runs cross-language examples.

<!-- run-disable -->

```bash
$ make examples-lang
```

The command supports the environment variables supported by each language-specific (`examples-<lang>`) command documented below.

This command is useful when wanting to glob for examples files, irrespective of language, for a particular package in order to compare cross-language behavior. 

* * *

### C

> **Note**: C examples commands delegate to local Makefiles which are responsible for actually compiling and running the respective examples.

#### examples-c

Runs C examples.

<!-- run-disable -->

```bash
$ make examples-c
```

The command supports the following environment variables:

-   **EXAMPLES_FILTER**: file path pattern; e.g., `.*/math/base/special/abs/.*`.
-   **BLAS**: BLAS library name; e.g., `openblas`.
-   **BLAS_DIR**: BLAS directory.
-   **C_COMPILER**: C compiler; e.g., `gcc`.

This command is useful when wanting to glob for C examples files (e.g., run all C examples for a particular package).

#### examples-c-files

Runs a specified list of C examples files.

<!-- run-disable -->

```bash
$ make examples-c-files FILES='/foo/example.c /bar/example.c'
```

The command supports the following environment variables:

-   **FILES**: list of C examples files.
-   **BLAS**: BLAS library name; e.g., `openblas`.
-   **BLAS_DIR**: BLAS directory.
-   **C_COMPILER**: C compiler; e.g., `gcc`.

This command is useful when wanting to run a list of C examples files generated by some other command (e.g., a filtered list of changed C examples files obtained via `git diff`).

* * *

### C++

> **Note**: C++ examples commands delegate to local Makefiles which are responsible for actually compiling and running the respective examples.

#### examples-cpp

Runs C++ examples.

<!-- run-disable -->

```bash
$ make examples-cpp
```

The command supports the following environment variables:

-   **EXAMPLES_FILTER**: file path pattern; e.g., `.*/math/base/special/beta/.*`.
-   **CXX_COMPILER**: C++ compiler; e.g., `g++`.

This command is useful when wanting to glob for C++ examples files (e.g., run all C++ examples for a particular package).

#### examples-cpp-files

Runs a specified list of C++ examples files.

<!-- run-disable -->

```bash
$ make examples-cpp-files FILES='/foo/example.cpp /bar/example.cpp'
```

The command supports the following environment variables:

-   **FILES**: list of C++ examples files.
-   **CXX_COMPILER**: C++ compiler; e.g., `g++`.

This command is useful when wanting to run a list of C++ examples files generated by some other command (e.g., a filtered list of changed C++ examples files obtained via `git diff`).

* * *

### JavaScript

#### examples-javascript

Runs JavaScript examples.

<!-- run-disable -->

```bash
$ make examples-javascript
```

The command supports the following environment variables:

-   **EXAMPLES_FILTER**: file path pattern; e.g., `.*/utils/group-by/.*`.

This command is useful when wanting to glob for JavaScript examples files (e.g., run all JavaScript examples for a particular package).

#### examples-javascript-files

Runs a specified list of JavaScript examples files.

<!-- run-disable -->

```bash
$ make examples-javascript-files FILES='/foo/example.js /bar/example.js'
```

The command supports the following environment variables:

-   **FILES**: list of JavaScript examples files.

This command is useful when wanting to run a list of JavaScript examples files generated by some other command (e.g., a filtered list of changed JavaScript examples files obtained via `git diff`).

* * *

### Markdown

#### markdown-examples

Runs examples found in Markdown files.

<!-- run-disable -->

```bash
$ make markdown-examples
```

The command supports the following environment variables:

-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/blas/base/dasum/.*`.

This command is an **alias** for `markdown-examples-javascript`, which is documented below.

#### markdown-javascript-examples

Runs JavaScript examples found in Markdown files.

<!-- run-disable -->

```bash
$ make markdown-javascript-examples
```

The command supports the following environment variables:

-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/blas/base/dasum/.*`.

This command is useful when wanting to glob for Markdown files which may contain JavaScript examples (e.g., run all JavaScript examples found in Markdown files for a particular package).

#### markdown-examples-javascript-files

Runs JavaScript examples found in a specified list of Markdown files.

<!-- run-disable -->

```bash
$ make markdown-examples-javascript-files FILES='/foo/README.md /bar/README.md'
```

The command supports the following environment variables:

-   **FILES**: list of Markdown files.

This command is useful when wanting to run JavaScript examples found in a list of Markdown files generated by some other command (e.g., a filtered list of changed Markdown files obtained via `git diff`).

</section>

<!-- /.usage -->

<!-- Section to include notes. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="notes">

</section>

<!-- /.notes -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[make]: https://www.gnu.org/software/make/

</section>

<!-- /.links -->
