#!/usr/bin/env bash
# nbdkit
# Copyright (C) 2014 Red Hat Inc.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# * Neither the name of Red Hat nor the names of its contributors may be
# used to endorse or promote products derived from this software without
# specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY RED HAT AND CONTRIBUTORS ''AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL RED HAT OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
# USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
# OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

source ./functions.sh
set -e
set -x

requires_single_mode
requires socat -h
requires_nbdinfo

sock=$(mktemp -u /tmp/nbdkit-test-sock.XXXXXX)
files="$sock single.disk"
rm -f $files

$TRUNCATE -s 1G single.disk

socat unix-listen:$sock,reuseaddr,fork \
    exec:'nbdkit -r -s file single.disk' &
pid=$!

cleanup ()
{
    kill $pid
    rm -f $files
}
cleanup_fn cleanup

# Wait for socat to start up and create the socket.
for i in {1..10}; do
    if test -S $sock; then
        break
    fi
    sleep 1
done
if ! test -S $sock; then
    echo "$0: socket was not created"
    exit 1
fi

nbdinfo "nbd+unix:///?socket=$sock"
