# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_transform import AbstractTransform


class GeneralTransform(AbstractTransform):
    r"""
    GeneralTransform - allows operations on any transforms
    
    Superclass: AbstractTransform
    
    GeneralTransform is like Transform and PerspectiveTransform,
    but it will work with any AbstractTransform as input.  It is not
    as efficient as the other two, however, because arbitrary
    transformations cannot be concatenated by matrix multiplication.
    Transform concatenation is simulated by passing each input point
    through each transform in turn.
    @sa
    Transform PerspectiveTransform
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGeneralTransform, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        r"""
        
        """
    )

    def get_concatenated_transform(self, *args):
        """
        get_concatenated_transform(self, i:int) -> AbstractTransform
        C++: AbstractTransform *get_concatenated_transform(int i)
        Get one of the concatenated transformations as a
        AbstractTransform. These transformations are applied, in
        series, every time the transformation of a coordinate occurs. 
        This method is provided to make it possible to decompose a
        transformation into its constituents, for example to save a
        transformation to a file.
        """
        ret = self._wrap_call(self._vtk_obj.GetConcatenatedTransform, *args)
        return wrap_vtk(ret)

    def _get_inverse_flag(self):
        return self._vtk_obj.GetInverseFlag()
    inverse_flag = traits.Property(_get_inverse_flag, desc=\
        r"""
        Get the inverse flag of the transformation.  This controls
        whether it is the Input or the inverse of the Input that is used
        as the base transformation.  The inverse_flag is flipped every
        time Inverse() is called.  The inverse_flag is off when a
        transform is first created.
        """
    )

    def _get_number_of_concatenated_transforms(self):
        return self._vtk_obj.GetNumberOfConcatenatedTransforms()
    number_of_concatenated_transforms = traits.Property(_get_number_of_concatenated_transforms, desc=\
        r"""
        Get the total number of transformations that are linked into this
        one via Concatenate() operations or via set_input().
        """
    )

    def concatenate(self, *args):
        """
        concatenate(self, matrix:Matrix4x4) -> None
        C++: void concatenate(Matrix4x4 *matrix)
        concatenate(self, elements:(float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float)) -> None
        C++: void concatenate(const double elements[16])
        concatenate(self, transform:AbstractTransform) -> None
        C++: void concatenate(AbstractTransform *transform)
        Concatenates the matrix with the current transformation according
        to pre_multiply or post_multiply semantics.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Concatenate, *my_args)
        return ret

    def identity(self):
        """
        identity(self) -> None
        C++: void identity()
        Set this transformation to the identity transformation.  If the
        transform has an Input, then the transformation will be reset so
        that it is the same as the Input.
        """
        ret = self._vtk_obj.Identity()
        return ret
        

    def pop(self):
        """
        pop(self) -> None
        C++: void pop()
        Deletes the transformation on the top of the stack and sets the
        top to the next transformation on the stack.
        """
        ret = self._vtk_obj.Pop()
        return ret
        

    def post_multiply(self):
        """
        post_multiply(self) -> None
        C++: void post_multiply()
        Sets the internal state of the transform to post_multiply. All
        subsequent operations will occur after those already represented
        in the current transformation.  In homogeneous matrix notation, M
        = A*M where M is the current transformation matrix and A is the
        applied matrix. The default is pre_multiply.
        """
        ret = self._vtk_obj.PostMultiply()
        return ret
        

    def pre_multiply(self):
        """
        pre_multiply(self) -> None
        C++: void pre_multiply()
        Sets the internal state of the transform to pre_multiply. All
        subsequent operations will occur before those already represented
        in the current transformation.  In homogeneous matrix notation, M
        = M*A where M is the current transformation matrix and A is the
        applied matrix. The default is pre_multiply.
        """
        ret = self._vtk_obj.PreMultiply()
        return ret
        

    def push(self):
        """
        push(self) -> None
        C++: void push()
        Pushes the current transformation onto the transformation stack.
        """
        ret = self._vtk_obj.Push()
        return ret
        

    def rotate_wxyz(self, *args):
        """
        rotate_wxyz(self, angle:float, x:float, y:float, z:float) -> None
        C++: void rotate_wxyz(double angle, double x, double y, double z)
        rotate_wxyz(self, angle:float, axis:(float, float, float)) -> None
        C++: void rotate_wxyz(double angle, const double axis[3])
        Create a rotation matrix and concatenate it with the current
        transformation according to pre_multiply or post_multiply
        semantics. The angle is in degrees, and (x,y,z) specifies the
        axis that the rotation will be performed around.
        """
        ret = self._wrap_call(self._vtk_obj.RotateWXYZ, *args)
        return ret

    def rotate_x(self, *args):
        """
        rotate_x(self, angle:float) -> None
        C++: void rotate_x(double angle)
        Create a rotation matrix about the X, Y, or Z axis and
        concatenate it with the current transformation according to
        pre_multiply or post_multiply semantics.  The angle is expressed in
        degrees.
        """
        ret = self._wrap_call(self._vtk_obj.RotateX, *args)
        return ret

    def rotate_y(self, *args):
        """
        rotate_y(self, angle:float) -> None
        C++: void rotate_y(double angle)"""
        ret = self._wrap_call(self._vtk_obj.RotateY, *args)
        return ret

    def rotate_z(self, *args):
        """
        rotate_z(self, angle:float) -> None
        C++: void rotate_z(double angle)"""
        ret = self._wrap_call(self._vtk_obj.RotateZ, *args)
        return ret

    def scale(self, *args):
        """
        scale(self, x:float, y:float, z:float) -> None
        C++: void scale(double x, double y, double z)
        scale(self, s:(float, float, float)) -> None
        C++: void scale(const double s[3])
        Create a scale matrix (i.e. set the diagonal elements to x, y, z)
        and concatenate it with the current transformation according to
        pre_multiply or post_multiply semantics.
        """
        ret = self._wrap_call(self._vtk_obj.Scale, *args)
        return ret

    def translate(self, *args):
        """
        translate(self, x:float, y:float, z:float) -> None
        C++: void translate(double x, double y, double z)
        translate(self, x:(float, float, float)) -> None
        C++: void translate(const double x[3])
        Create a translation matrix and concatenate it with the current
        transformation according to pre_multiply or post_multiply
        semantics.
        """
        ret = self._wrap_call(self._vtk_obj.Translate, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GeneralTransform, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GeneralTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit GeneralTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GeneralTransform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

