.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_error_init.mdoc -- initialize zip_error
.\" Copyright (C) 2014-2017 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_ERROR_INIT" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_error_init\fR,
\fBzip_error_init_with_code\fR
\- initialize zip_error structure
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIvoid\fR
.br
.PD 0
.HP 4n
\fBzip_error_init\fR(\fIzip_error_t\ *error\fR);
.PD
.PP
\fIvoid\fR
.br
.PD 0
.HP 4n
\fBzip_error_init_with_code\fR(\fIzip_error_t\ *error\fR, \fIint\ ze\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_error_init\fR()
function initializes the zip_error pointed to by
\fIerror\fR.
\fI*error\fR
must be allocated before calling
\fBzip_error_init\fR().
.PP
The
\fBzip_error_init_with_code\fR()
function does the same, but additionally sets the zip error code to
\fIze\fR
and sets the system error code to the current
errno(3)
value, if appropriate.
.SH "SEE ALSO"
libzip(3),
zip_error_fini(3)
.SH "HISTORY"
\fBzip_error_init\fR()
and
\fBzip_error_init_with_code\fR()
were added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
