/*
 * (C) Copyright 2014-2016, by Dimitrios Michail
 *
 * JHeaps Library
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jheaps.array;

import java.util.Comparator;

import org.jheaps.DoubleEndedHeap;
import org.jheaps.tree.AbstractDoubleEndedHeapTest;

public class MinMaxBinaryArrayDoubleEndedHeapTest extends AbstractDoubleEndedHeapTest {

    protected DoubleEndedHeap<Long> createHeap() {
        return new MinMaxBinaryArrayDoubleEndedHeap<Long>();
    }

    protected DoubleEndedHeap<Long> createHeap(int capacity) {
        return new MinMaxBinaryArrayDoubleEndedHeap<Long>(capacity);
    }

    @Override
    protected DoubleEndedHeap<Long> createHeap(Comparator<Long> comparator) {
        return new MinMaxBinaryArrayDoubleEndedHeap<Long>(comparator);
    }

}
