/***********************************************************************
 * SPDX-FileCopyrightText: 2003-2004 Max Howell <max.howell@methylblue.com>
 * SPDX-FileCopyrightText: 2008-2009 Martin Sandsmark <martin.sandsmark@kde.org>
 *
 * SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 ***********************************************************************/

#pragma once

#include "ui_dialog.h" //generated by uic

#include "Config.h" // Dirty

#include <QCloseEvent>
#include <QDialog>
#include <QTimer>

class QButtonGroup;

class SettingsDialog : public QDialog, public Ui::Dialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget * = nullptr);

protected:
    void closeEvent(QCloseEvent *) override;
    void reject() override;

public Q_SLOTS:
    void addFolder();
    void removeFolder();
    void toggleScanAcrossMounts(bool);
    void toggleDontScanRemoteMounts(bool);
    void reset();
    void startTimer();
    void toggleUseAntialiasing(bool = true);
    void toggleVaryLabelFontSizes(bool);
    void changeContrast(int);
    void changeScheme(QAbstractButton *button);
    void changeMinFontPitch(int);
    void toggleShowSmallFiles(bool);

Q_SIGNALS:
    void mapIsInvalid();
    void canvasIsDirty(const Dirty filth);

private:
    QTimer m_timer;

    static const uint TIMEOUT = 1000;

    QButtonGroup *m_schemaGroup;
};
