// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: pkg/kascfg/kascfg.proto

package kascfg

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ListenAgentCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ListenAgentCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenAgentCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ListenAgentCFMultiError, or
// nil if none found.
func (m *ListenAgentCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenAgentCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Address

	// no validation rules for Websocket

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	// no validation rules for ConnectionsPerTokenPerMinute

	if d := m.GetMaxConnectionAge(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenAgentCFValidationError{
				field:  "MaxConnectionAge",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenAgentCFValidationError{
					field:  "MaxConnectionAge",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetListenGracePeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenAgentCFValidationError{
				field:  "ListenGracePeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenAgentCFValidationError{
					field:  "ListenGracePeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if m.Network != nil {

		if _, ok := _ListenAgentCF_Network_InLookup[m.GetNetwork()]; !ok {
			err := ListenAgentCFValidationError{
				field:  "Network",
				reason: "value must be in list [tcp tcp4 tcp6 unix]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ListenAgentCFMultiError(errors)
	}

	return nil
}

// ListenAgentCFMultiError is an error wrapping multiple validation errors
// returned by ListenAgentCF.ValidateAll() if the designated constraints
// aren't met.
type ListenAgentCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenAgentCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenAgentCFMultiError) AllErrors() []error { return m }

// ListenAgentCFValidationError is the validation error returned by
// ListenAgentCF.Validate if the designated constraints aren't met.
type ListenAgentCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenAgentCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenAgentCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenAgentCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenAgentCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenAgentCFValidationError) ErrorName() string { return "ListenAgentCFValidationError" }

// Error satisfies the builtin error interface
func (e ListenAgentCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenAgentCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenAgentCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenAgentCFValidationError{}

var _ListenAgentCF_Network_InLookup = map[string]struct{}{
	"tcp":  {},
	"tcp4": {},
	"tcp6": {},
	"unix": {},
}

// Validate checks the field values on PrometheusCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *PrometheusCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PrometheusCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in PrometheusCFMultiError, or
// nil if none found.
func (m *PrometheusCF) ValidateAll() error {
	return m.validate(true)
}

func (m *PrometheusCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UrlPath

	if len(errors) > 0 {
		return PrometheusCFMultiError(errors)
	}

	return nil
}

// PrometheusCFMultiError is an error wrapping multiple validation errors
// returned by PrometheusCF.ValidateAll() if the designated constraints aren't met.
type PrometheusCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PrometheusCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PrometheusCFMultiError) AllErrors() []error { return m }

// PrometheusCFValidationError is the validation error returned by
// PrometheusCF.Validate if the designated constraints aren't met.
type PrometheusCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PrometheusCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PrometheusCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PrometheusCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PrometheusCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PrometheusCFValidationError) ErrorName() string { return "PrometheusCFValidationError" }

// Error satisfies the builtin error interface
func (e PrometheusCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPrometheusCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PrometheusCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PrometheusCFValidationError{}

// Validate checks the field values on ObservabilityListenCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ObservabilityListenCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObservabilityListenCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ObservabilityListenCFMultiError, or nil if none found.
func (m *ObservabilityListenCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ObservabilityListenCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Address

	if m.Network != nil {

		if _, ok := _ObservabilityListenCF_Network_InLookup[m.GetNetwork()]; !ok {
			err := ObservabilityListenCFValidationError{
				field:  "Network",
				reason: "value must be in list [tcp tcp4 tcp6 unix]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.CertificateFile != nil {

		if len(m.GetCertificateFile()) < 1 {
			err := ObservabilityListenCFValidationError{
				field:  "CertificateFile",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.KeyFile != nil {

		if len(m.GetKeyFile()) < 1 {
			err := ObservabilityListenCFValidationError{
				field:  "KeyFile",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ObservabilityListenCFMultiError(errors)
	}

	return nil
}

// ObservabilityListenCFMultiError is an error wrapping multiple validation
// errors returned by ObservabilityListenCF.ValidateAll() if the designated
// constraints aren't met.
type ObservabilityListenCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObservabilityListenCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObservabilityListenCFMultiError) AllErrors() []error { return m }

// ObservabilityListenCFValidationError is the validation error returned by
// ObservabilityListenCF.Validate if the designated constraints aren't met.
type ObservabilityListenCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObservabilityListenCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObservabilityListenCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObservabilityListenCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObservabilityListenCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObservabilityListenCFValidationError) ErrorName() string {
	return "ObservabilityListenCFValidationError"
}

// Error satisfies the builtin error interface
func (e ObservabilityListenCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObservabilityListenCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObservabilityListenCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObservabilityListenCFValidationError{}

var _ObservabilityListenCF_Network_InLookup = map[string]struct{}{
	"tcp":  {},
	"tcp4": {},
	"tcp6": {},
	"unix": {},
}

// Validate checks the field values on TracingCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TracingCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TracingCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TracingCFMultiError, or nil
// if none found.
func (m *TracingCF) ValidateAll() error {
	return m.validate(true)
}

func (m *TracingCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetOtlpEndpoint()) < 1 {
		err := TracingCFValidationError{
			field:  "OtlpEndpoint",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.OtlpTokenSecretFile != nil {

		if len(m.GetOtlpTokenSecretFile()) < 1 {
			err := TracingCFValidationError{
				field:  "OtlpTokenSecretFile",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.OtlpCaCertificateFile != nil {

		if len(m.GetOtlpCaCertificateFile()) < 1 {
			err := TracingCFValidationError{
				field:  "OtlpCaCertificateFile",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.OtlpLegacyEndpoint != nil {

		if len(m.GetOtlpLegacyEndpoint()) < 1 {
			err := TracingCFValidationError{
				field:  "OtlpLegacyEndpoint",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return TracingCFMultiError(errors)
	}

	return nil
}

// TracingCFMultiError is an error wrapping multiple validation errors returned
// by TracingCF.ValidateAll() if the designated constraints aren't met.
type TracingCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TracingCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TracingCFMultiError) AllErrors() []error { return m }

// TracingCFValidationError is the validation error returned by
// TracingCF.Validate if the designated constraints aren't met.
type TracingCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TracingCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TracingCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TracingCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TracingCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TracingCFValidationError) ErrorName() string { return "TracingCFValidationError" }

// Error satisfies the builtin error interface
func (e TracingCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTracingCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TracingCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TracingCFValidationError{}

// Validate checks the field values on LoggingCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LoggingCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LoggingCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LoggingCFMultiError, or nil
// if none found.
func (m *LoggingCF) ValidateAll() error {
	return m.validate(true)
}

func (m *LoggingCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Level

	if m.GrpcLevel != nil {
		// no validation rules for GrpcLevel
	}

	if len(errors) > 0 {
		return LoggingCFMultiError(errors)
	}

	return nil
}

// LoggingCFMultiError is an error wrapping multiple validation errors returned
// by LoggingCF.ValidateAll() if the designated constraints aren't met.
type LoggingCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LoggingCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LoggingCFMultiError) AllErrors() []error { return m }

// LoggingCFValidationError is the validation error returned by
// LoggingCF.Validate if the designated constraints aren't met.
type LoggingCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoggingCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoggingCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoggingCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoggingCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoggingCFValidationError) ErrorName() string { return "LoggingCFValidationError" }

// Error satisfies the builtin error interface
func (e LoggingCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoggingCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoggingCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoggingCFValidationError{}

// Validate checks the field values on GitLabCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitLabCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitLabCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitLabCFMultiError, or nil
// if none found.
func (m *GitLabCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GitLabCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetAddress()) < 1 {
		err := GitLabCFValidationError{
			field:  "Address",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if uri, err := url.Parse(m.GetAddress()); err != nil {
		err = GitLabCFValidationError{
			field:  "Address",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	} else if !uri.IsAbs() {
		err := GitLabCFValidationError{
			field:  "Address",
			reason: "value must be absolute",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetAuthenticationSecretFile()) < 1 {
		err := GitLabCFValidationError{
			field:  "AuthenticationSecretFile",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for CaCertificateFile

	if all {
		switch v := interface{}(m.GetApiRateLimit()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GitLabCFValidationError{
					field:  "ApiRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GitLabCFValidationError{
					field:  "ApiRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetApiRateLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GitLabCFValidationError{
				field:  "ApiRateLimit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.ExternalUrl != nil {

		if len(m.GetExternalUrl()) < 1 {
			err := GitLabCFValidationError{
				field:  "ExternalUrl",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if uri, err := url.Parse(m.GetExternalUrl()); err != nil {
			err = GitLabCFValidationError{
				field:  "ExternalUrl",
				reason: "value must be a valid URI",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else if !uri.IsAbs() {
			err := GitLabCFValidationError{
				field:  "ExternalUrl",
				reason: "value must be absolute",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return GitLabCFMultiError(errors)
	}

	return nil
}

// GitLabCFMultiError is an error wrapping multiple validation errors returned
// by GitLabCF.ValidateAll() if the designated constraints aren't met.
type GitLabCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitLabCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitLabCFMultiError) AllErrors() []error { return m }

// GitLabCFValidationError is the validation error returned by
// GitLabCF.Validate if the designated constraints aren't met.
type GitLabCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitLabCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitLabCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitLabCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitLabCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitLabCFValidationError) ErrorName() string { return "GitLabCFValidationError" }

// Error satisfies the builtin error interface
func (e GitLabCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitLabCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitLabCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitLabCFValidationError{}

// Validate checks the field values on GitopsCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitopsCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitopsCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitopsCFMultiError, or nil
// if none found.
func (m *GitopsCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GitopsCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetPollPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = GitopsCFValidationError{
				field:  "PollPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := GitopsCFValidationError{
					field:  "PollPeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetProjectInfoCacheTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = GitopsCFValidationError{
				field:  "ProjectInfoCacheTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := GitopsCFValidationError{
					field:  "ProjectInfoCacheTtl",
					reason: "value must be greater than or equal to 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetProjectInfoCacheErrorTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = GitopsCFValidationError{
				field:  "ProjectInfoCacheErrorTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := GitopsCFValidationError{
					field:  "ProjectInfoCacheErrorTtl",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	// no validation rules for MaxManifestFileSize

	// no validation rules for MaxTotalManifestFileSize

	// no validation rules for MaxNumberOfPaths

	// no validation rules for MaxNumberOfFiles

	if len(errors) > 0 {
		return GitopsCFMultiError(errors)
	}

	return nil
}

// GitopsCFMultiError is an error wrapping multiple validation errors returned
// by GitopsCF.ValidateAll() if the designated constraints aren't met.
type GitopsCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitopsCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitopsCFMultiError) AllErrors() []error { return m }

// GitopsCFValidationError is the validation error returned by
// GitopsCF.Validate if the designated constraints aren't met.
type GitopsCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitopsCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitopsCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitopsCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitopsCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitopsCFValidationError) ErrorName() string { return "GitopsCFValidationError" }

// Error satisfies the builtin error interface
func (e GitopsCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitopsCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitopsCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitopsCFValidationError{}

// Validate checks the field values on RemoteDevelopmentCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RemoteDevelopmentCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RemoteDevelopmentCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RemoteDevelopmentCFMultiError, or nil if none found.
func (m *RemoteDevelopmentCF) ValidateAll() error {
	return m.validate(true)
}

func (m *RemoteDevelopmentCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetPollPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RemoteDevelopmentCFValidationError{
				field:  "PollPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RemoteDevelopmentCFValidationError{
					field:  "PollPeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return RemoteDevelopmentCFMultiError(errors)
	}

	return nil
}

// RemoteDevelopmentCFMultiError is an error wrapping multiple validation
// errors returned by RemoteDevelopmentCF.ValidateAll() if the designated
// constraints aren't met.
type RemoteDevelopmentCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RemoteDevelopmentCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RemoteDevelopmentCFMultiError) AllErrors() []error { return m }

// RemoteDevelopmentCFValidationError is the validation error returned by
// RemoteDevelopmentCF.Validate if the designated constraints aren't met.
type RemoteDevelopmentCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RemoteDevelopmentCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RemoteDevelopmentCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RemoteDevelopmentCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RemoteDevelopmentCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RemoteDevelopmentCFValidationError) ErrorName() string {
	return "RemoteDevelopmentCFValidationError"
}

// Error satisfies the builtin error interface
func (e RemoteDevelopmentCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRemoteDevelopmentCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RemoteDevelopmentCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RemoteDevelopmentCFValidationError{}

// Validate checks the field values on SentryCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *SentryCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SentryCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SentryCFMultiError, or nil
// if none found.
func (m *SentryCF) ValidateAll() error {
	return m.validate(true)
}

func (m *SentryCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Dsn

	// no validation rules for Environment

	if len(errors) > 0 {
		return SentryCFMultiError(errors)
	}

	return nil
}

// SentryCFMultiError is an error wrapping multiple validation errors returned
// by SentryCF.ValidateAll() if the designated constraints aren't met.
type SentryCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SentryCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SentryCFMultiError) AllErrors() []error { return m }

// SentryCFValidationError is the validation error returned by
// SentryCF.Validate if the designated constraints aren't met.
type SentryCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SentryCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SentryCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SentryCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SentryCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SentryCFValidationError) ErrorName() string { return "SentryCFValidationError" }

// Error satisfies the builtin error interface
func (e SentryCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSentryCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SentryCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SentryCFValidationError{}

// Validate checks the field values on ListenKubernetesApiCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ListenKubernetesApiCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenKubernetesApiCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListenKubernetesApiCFMultiError, or nil if none found.
func (m *ListenKubernetesApiCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenKubernetesApiCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Address

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	if d := m.GetListenGracePeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenKubernetesApiCFValidationError{
				field:  "ListenGracePeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenKubernetesApiCFValidationError{
					field:  "ListenGracePeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetShutdownGracePeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenKubernetesApiCFValidationError{
				field:  "ShutdownGracePeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenKubernetesApiCFValidationError{
					field:  "ShutdownGracePeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if m.Network != nil {

		if _, ok := _ListenKubernetesApiCF_Network_InLookup[m.GetNetwork()]; !ok {
			err := ListenKubernetesApiCFValidationError{
				field:  "Network",
				reason: "value must be in list [tcp tcp4 tcp6 unix]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ListenKubernetesApiCFMultiError(errors)
	}

	return nil
}

// ListenKubernetesApiCFMultiError is an error wrapping multiple validation
// errors returned by ListenKubernetesApiCF.ValidateAll() if the designated
// constraints aren't met.
type ListenKubernetesApiCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenKubernetesApiCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenKubernetesApiCFMultiError) AllErrors() []error { return m }

// ListenKubernetesApiCFValidationError is the validation error returned by
// ListenKubernetesApiCF.Validate if the designated constraints aren't met.
type ListenKubernetesApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenKubernetesApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenKubernetesApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenKubernetesApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenKubernetesApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenKubernetesApiCFValidationError) ErrorName() string {
	return "ListenKubernetesApiCFValidationError"
}

// Error satisfies the builtin error interface
func (e ListenKubernetesApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenKubernetesApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenKubernetesApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenKubernetesApiCFValidationError{}

var _ListenKubernetesApiCF_Network_InLookup = map[string]struct{}{
	"tcp":  {},
	"tcp4": {},
	"tcp6": {},
	"unix": {},
}

// Validate checks the field values on KubernetesApiCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *KubernetesApiCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on KubernetesApiCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// KubernetesApiCFMultiError, or nil if none found.
func (m *KubernetesApiCF) ValidateAll() error {
	return m.validate(true)
}

func (m *KubernetesApiCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetListen()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, KubernetesApiCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, KubernetesApiCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return KubernetesApiCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UrlPathPrefix

	if d := m.GetAllowedAgentCacheTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = KubernetesApiCFValidationError{
				field:  "AllowedAgentCacheTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := KubernetesApiCFValidationError{
					field:  "AllowedAgentCacheTtl",
					reason: "value must be greater than or equal to 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetAllowedAgentCacheErrorTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = KubernetesApiCFValidationError{
				field:  "AllowedAgentCacheErrorTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := KubernetesApiCFValidationError{
					field:  "AllowedAgentCacheErrorTtl",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return KubernetesApiCFMultiError(errors)
	}

	return nil
}

// KubernetesApiCFMultiError is an error wrapping multiple validation errors
// returned by KubernetesApiCF.ValidateAll() if the designated constraints
// aren't met.
type KubernetesApiCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m KubernetesApiCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m KubernetesApiCFMultiError) AllErrors() []error { return m }

// KubernetesApiCFValidationError is the validation error returned by
// KubernetesApiCF.Validate if the designated constraints aren't met.
type KubernetesApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e KubernetesApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e KubernetesApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e KubernetesApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e KubernetesApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e KubernetesApiCFValidationError) ErrorName() string { return "KubernetesApiCFValidationError" }

// Error satisfies the builtin error interface
func (e KubernetesApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sKubernetesApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = KubernetesApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = KubernetesApiCFValidationError{}

// Validate checks the field values on AgentCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AgentCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AgentCF with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in AgentCFMultiError, or nil if none found.
func (m *AgentCF) ValidateAll() error {
	return m.validate(true)
}

func (m *AgentCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetListen()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetConfiguration()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "Configuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "Configuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfiguration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "Configuration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGitops()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "Gitops",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "Gitops",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitops()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "Gitops",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetInfoCacheTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = AgentCFValidationError{
				field:  "InfoCacheTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := AgentCFValidationError{
					field:  "InfoCacheTtl",
					reason: "value must be greater than or equal to 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetInfoCacheErrorTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = AgentCFValidationError{
				field:  "InfoCacheErrorTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := AgentCFValidationError{
					field:  "InfoCacheErrorTtl",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetRedisConnInfoTtl()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RedisConnInfoTtl",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RedisConnInfoTtl",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRedisConnInfoTtl()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "RedisConnInfoTtl",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRedisConnInfoRefresh()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RedisConnInfoRefresh",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RedisConnInfoRefresh",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRedisConnInfoRefresh()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "RedisConnInfoRefresh",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRedisConnInfoGc()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RedisConnInfoGc",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RedisConnInfoGc",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRedisConnInfoGc()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "RedisConnInfoGc",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetKubernetesApi()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "KubernetesApi",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "KubernetesApi",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetKubernetesApi()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "KubernetesApi",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRemoteDevelopment()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RemoteDevelopment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentCFValidationError{
					field:  "RemoteDevelopment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRemoteDevelopment()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentCFValidationError{
				field:  "RemoteDevelopment",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AgentCFMultiError(errors)
	}

	return nil
}

// AgentCFMultiError is an error wrapping multiple validation errors returned
// by AgentCF.ValidateAll() if the designated constraints aren't met.
type AgentCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AgentCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AgentCFMultiError) AllErrors() []error { return m }

// AgentCFValidationError is the validation error returned by AgentCF.Validate
// if the designated constraints aren't met.
type AgentCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AgentCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AgentCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AgentCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AgentCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AgentCFValidationError) ErrorName() string { return "AgentCFValidationError" }

// Error satisfies the builtin error interface
func (e AgentCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAgentCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AgentCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AgentCFValidationError{}

// Validate checks the field values on AgentConfigurationCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AgentConfigurationCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AgentConfigurationCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AgentConfigurationCFMultiError, or nil if none found.
func (m *AgentConfigurationCF) ValidateAll() error {
	return m.validate(true)
}

func (m *AgentConfigurationCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetPollPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = AgentConfigurationCFValidationError{
				field:  "PollPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := AgentConfigurationCFValidationError{
					field:  "PollPeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	// no validation rules for MaxConfigurationFileSize

	if len(errors) > 0 {
		return AgentConfigurationCFMultiError(errors)
	}

	return nil
}

// AgentConfigurationCFMultiError is an error wrapping multiple validation
// errors returned by AgentConfigurationCF.ValidateAll() if the designated
// constraints aren't met.
type AgentConfigurationCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AgentConfigurationCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AgentConfigurationCFMultiError) AllErrors() []error { return m }

// AgentConfigurationCFValidationError is the validation error returned by
// AgentConfigurationCF.Validate if the designated constraints aren't met.
type AgentConfigurationCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AgentConfigurationCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AgentConfigurationCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AgentConfigurationCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AgentConfigurationCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AgentConfigurationCFValidationError) ErrorName() string {
	return "AgentConfigurationCFValidationError"
}

// Error satisfies the builtin error interface
func (e AgentConfigurationCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAgentConfigurationCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AgentConfigurationCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AgentConfigurationCFValidationError{}

// Validate checks the field values on GoogleProfilerCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *GoogleProfilerCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GoogleProfilerCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GoogleProfilerCFMultiError, or nil if none found.
func (m *GoogleProfilerCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GoogleProfilerCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Enabled

	// no validation rules for ProjectId

	// no validation rules for CredentialsFile

	// no validation rules for DebugLogging

	if len(errors) > 0 {
		return GoogleProfilerCFMultiError(errors)
	}

	return nil
}

// GoogleProfilerCFMultiError is an error wrapping multiple validation errors
// returned by GoogleProfilerCF.ValidateAll() if the designated constraints
// aren't met.
type GoogleProfilerCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GoogleProfilerCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GoogleProfilerCFMultiError) AllErrors() []error { return m }

// GoogleProfilerCFValidationError is the validation error returned by
// GoogleProfilerCF.Validate if the designated constraints aren't met.
type GoogleProfilerCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GoogleProfilerCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GoogleProfilerCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GoogleProfilerCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GoogleProfilerCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GoogleProfilerCFValidationError) ErrorName() string { return "GoogleProfilerCFValidationError" }

// Error satisfies the builtin error interface
func (e GoogleProfilerCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGoogleProfilerCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GoogleProfilerCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GoogleProfilerCFValidationError{}

// Validate checks the field values on LivenessProbeCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *LivenessProbeCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LivenessProbeCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// LivenessProbeCFMultiError, or nil if none found.
func (m *LivenessProbeCF) ValidateAll() error {
	return m.validate(true)
}

func (m *LivenessProbeCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UrlPath

	if len(errors) > 0 {
		return LivenessProbeCFMultiError(errors)
	}

	return nil
}

// LivenessProbeCFMultiError is an error wrapping multiple validation errors
// returned by LivenessProbeCF.ValidateAll() if the designated constraints
// aren't met.
type LivenessProbeCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LivenessProbeCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LivenessProbeCFMultiError) AllErrors() []error { return m }

// LivenessProbeCFValidationError is the validation error returned by
// LivenessProbeCF.Validate if the designated constraints aren't met.
type LivenessProbeCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LivenessProbeCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LivenessProbeCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LivenessProbeCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LivenessProbeCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LivenessProbeCFValidationError) ErrorName() string { return "LivenessProbeCFValidationError" }

// Error satisfies the builtin error interface
func (e LivenessProbeCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLivenessProbeCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LivenessProbeCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LivenessProbeCFValidationError{}

// Validate checks the field values on ReadinessProbeCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ReadinessProbeCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadinessProbeCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ReadinessProbeCFMultiError, or nil if none found.
func (m *ReadinessProbeCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadinessProbeCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UrlPath

	if len(errors) > 0 {
		return ReadinessProbeCFMultiError(errors)
	}

	return nil
}

// ReadinessProbeCFMultiError is an error wrapping multiple validation errors
// returned by ReadinessProbeCF.ValidateAll() if the designated constraints
// aren't met.
type ReadinessProbeCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadinessProbeCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadinessProbeCFMultiError) AllErrors() []error { return m }

// ReadinessProbeCFValidationError is the validation error returned by
// ReadinessProbeCF.Validate if the designated constraints aren't met.
type ReadinessProbeCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadinessProbeCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadinessProbeCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadinessProbeCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadinessProbeCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadinessProbeCFValidationError) ErrorName() string { return "ReadinessProbeCFValidationError" }

// Error satisfies the builtin error interface
func (e ReadinessProbeCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadinessProbeCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadinessProbeCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadinessProbeCFValidationError{}

// Validate checks the field values on ObservabilityCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ObservabilityCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObservabilityCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ObservabilityCFMultiError, or nil if none found.
func (m *ObservabilityCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ObservabilityCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetUsageReportingPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ObservabilityCFValidationError{
				field:  "UsageReportingPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := ObservabilityCFValidationError{
					field:  "UsageReportingPeriod",
					reason: "value must be greater than or equal to 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetListen()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPrometheus()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Prometheus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Prometheus",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrometheus()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Prometheus",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTracing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetSentry()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Sentry",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Sentry",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSentry()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Sentry",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetLogging()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Logging",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Logging",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLogging()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Logging",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGoogleProfiler()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "GoogleProfiler",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "GoogleProfiler",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGoogleProfiler()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "GoogleProfiler",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetLivenessProbe()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "LivenessProbe",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "LivenessProbe",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLivenessProbe()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "LivenessProbe",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetReadinessProbe()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "ReadinessProbe",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "ReadinessProbe",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetReadinessProbe()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "ReadinessProbe",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetEventReportingPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ObservabilityCFValidationError{
				field:  "EventReportingPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := ObservabilityCFValidationError{
					field:  "EventReportingPeriod",
					reason: "value must be greater than or equal to 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return ObservabilityCFMultiError(errors)
	}

	return nil
}

// ObservabilityCFMultiError is an error wrapping multiple validation errors
// returned by ObservabilityCF.ValidateAll() if the designated constraints
// aren't met.
type ObservabilityCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObservabilityCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObservabilityCFMultiError) AllErrors() []error { return m }

// ObservabilityCFValidationError is the validation error returned by
// ObservabilityCF.Validate if the designated constraints aren't met.
type ObservabilityCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObservabilityCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObservabilityCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObservabilityCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObservabilityCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObservabilityCFValidationError) ErrorName() string { return "ObservabilityCFValidationError" }

// Error satisfies the builtin error interface
func (e ObservabilityCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObservabilityCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObservabilityCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObservabilityCFValidationError{}

// Validate checks the field values on TokenBucketRateLimitCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TokenBucketRateLimitCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TokenBucketRateLimitCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TokenBucketRateLimitCFMultiError, or nil if none found.
func (m *TokenBucketRateLimitCF) ValidateAll() error {
	return m.validate(true)
}

func (m *TokenBucketRateLimitCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetRefillRatePerSecond() < 0 {
		err := TokenBucketRateLimitCFValidationError{
			field:  "RefillRatePerSecond",
			reason: "value must be greater than or equal to 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for BucketSize

	if len(errors) > 0 {
		return TokenBucketRateLimitCFMultiError(errors)
	}

	return nil
}

// TokenBucketRateLimitCFMultiError is an error wrapping multiple validation
// errors returned by TokenBucketRateLimitCF.ValidateAll() if the designated
// constraints aren't met.
type TokenBucketRateLimitCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TokenBucketRateLimitCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TokenBucketRateLimitCFMultiError) AllErrors() []error { return m }

// TokenBucketRateLimitCFValidationError is the validation error returned by
// TokenBucketRateLimitCF.Validate if the designated constraints aren't met.
type TokenBucketRateLimitCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TokenBucketRateLimitCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TokenBucketRateLimitCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TokenBucketRateLimitCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TokenBucketRateLimitCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TokenBucketRateLimitCFValidationError) ErrorName() string {
	return "TokenBucketRateLimitCFValidationError"
}

// Error satisfies the builtin error interface
func (e TokenBucketRateLimitCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTokenBucketRateLimitCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TokenBucketRateLimitCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TokenBucketRateLimitCFValidationError{}

// Validate checks the field values on GitalyCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitalyCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitalyCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitalyCFMultiError, or nil
// if none found.
func (m *GitalyCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GitalyCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetGlobalApiRateLimit()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GitalyCFValidationError{
					field:  "GlobalApiRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GitalyCFValidationError{
					field:  "GlobalApiRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGlobalApiRateLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GitalyCFValidationError{
				field:  "GlobalApiRateLimit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPerServerApiRateLimit()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GitalyCFValidationError{
					field:  "PerServerApiRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GitalyCFValidationError{
					field:  "PerServerApiRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPerServerApiRateLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GitalyCFValidationError{
				field:  "PerServerApiRateLimit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return GitalyCFMultiError(errors)
	}

	return nil
}

// GitalyCFMultiError is an error wrapping multiple validation errors returned
// by GitalyCF.ValidateAll() if the designated constraints aren't met.
type GitalyCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitalyCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitalyCFMultiError) AllErrors() []error { return m }

// GitalyCFValidationError is the validation error returned by
// GitalyCF.Validate if the designated constraints aren't met.
type GitalyCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitalyCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitalyCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitalyCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitalyCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitalyCFValidationError) ErrorName() string { return "GitalyCFValidationError" }

// Error satisfies the builtin error interface
func (e GitalyCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitalyCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitalyCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitalyCFValidationError{}

// Validate checks the field values on RedisCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RedisCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisCF with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in RedisCFMultiError, or nil if none found.
func (m *RedisCF) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for PoolSize

	if d := m.GetDialTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RedisCFValidationError{
				field:  "DialTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RedisCFValidationError{
					field:  "DialTimeout",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetReadTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RedisCFValidationError{
				field:  "ReadTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RedisCFValidationError{
					field:  "ReadTimeout",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetWriteTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RedisCFValidationError{
				field:  "WriteTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RedisCFValidationError{
					field:  "WriteTimeout",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetIdleTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RedisCFValidationError{
				field:  "IdleTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RedisCFValidationError{
					field:  "IdleTimeout",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	// no validation rules for KeyPrefix

	// no validation rules for Username

	// no validation rules for PasswordFile

	if _, ok := _RedisCF_Network_InLookup[m.GetNetwork()]; !ok {
		err := RedisCFValidationError{
			field:  "Network",
			reason: "value must be in list [ tcp unix]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTls()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisCFValidationError{
					field:  "Tls",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisCFValidationError{
					field:  "Tls",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTls()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisCFValidationError{
				field:  "Tls",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetDatabaseIndex() < 0 {
		err := RedisCFValidationError{
			field:  "DatabaseIndex",
			reason: "value must be greater than or equal to 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Password

	// no validation rules for PipelineMultiplex

	oneofRedisConfigPresent := false
	switch v := m.RedisConfig.(type) {
	case *RedisCF_Server:
		if v == nil {
			err := RedisCFValidationError{
				field:  "RedisConfig",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRedisConfigPresent = true

		if m.GetServer() == nil {
			err := RedisCFValidationError{
				field:  "Server",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetServer()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RedisCFValidationError{
						field:  "Server",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RedisCFValidationError{
						field:  "Server",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetServer()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisCFValidationError{
					field:  "Server",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RedisCF_Sentinel:
		if v == nil {
			err := RedisCFValidationError{
				field:  "RedisConfig",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRedisConfigPresent = true

		if m.GetSentinel() == nil {
			err := RedisCFValidationError{
				field:  "Sentinel",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetSentinel()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RedisCFValidationError{
						field:  "Sentinel",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RedisCFValidationError{
						field:  "Sentinel",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetSentinel()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisCFValidationError{
					field:  "Sentinel",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRedisConfigPresent {
		err := RedisCFValidationError{
			field:  "RedisConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RedisCFMultiError(errors)
	}

	return nil
}

// RedisCFMultiError is an error wrapping multiple validation errors returned
// by RedisCF.ValidateAll() if the designated constraints aren't met.
type RedisCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisCFMultiError) AllErrors() []error { return m }

// RedisCFValidationError is the validation error returned by RedisCF.Validate
// if the designated constraints aren't met.
type RedisCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisCFValidationError) ErrorName() string { return "RedisCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisCFValidationError{}

var _RedisCF_Network_InLookup = map[string]struct{}{
	"":     {},
	"tcp":  {},
	"unix": {},
}

// Validate checks the field values on RedisTLSCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RedisTLSCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisTLSCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RedisTLSCFMultiError, or
// nil if none found.
func (m *RedisTLSCF) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisTLSCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Enabled

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	// no validation rules for CaCertificateFile

	if len(errors) > 0 {
		return RedisTLSCFMultiError(errors)
	}

	return nil
}

// RedisTLSCFMultiError is an error wrapping multiple validation errors
// returned by RedisTLSCF.ValidateAll() if the designated constraints aren't met.
type RedisTLSCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisTLSCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisTLSCFMultiError) AllErrors() []error { return m }

// RedisTLSCFValidationError is the validation error returned by
// RedisTLSCF.Validate if the designated constraints aren't met.
type RedisTLSCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisTLSCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisTLSCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisTLSCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisTLSCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisTLSCFValidationError) ErrorName() string { return "RedisTLSCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisTLSCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisTLSCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisTLSCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisTLSCFValidationError{}

// Validate checks the field values on RedisServerCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RedisServerCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisServerCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RedisServerCFMultiError, or
// nil if none found.
func (m *RedisServerCF) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisServerCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetAddress()) < 1 {
		err := RedisServerCFValidationError{
			field:  "Address",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RedisServerCFMultiError(errors)
	}

	return nil
}

// RedisServerCFMultiError is an error wrapping multiple validation errors
// returned by RedisServerCF.ValidateAll() if the designated constraints
// aren't met.
type RedisServerCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisServerCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisServerCFMultiError) AllErrors() []error { return m }

// RedisServerCFValidationError is the validation error returned by
// RedisServerCF.Validate if the designated constraints aren't met.
type RedisServerCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisServerCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisServerCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisServerCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisServerCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisServerCFValidationError) ErrorName() string { return "RedisServerCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisServerCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisServerCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisServerCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisServerCFValidationError{}

// Validate checks the field values on RedisSentinelCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RedisSentinelCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisSentinelCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RedisSentinelCFMultiError, or nil if none found.
func (m *RedisSentinelCF) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisSentinelCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetMasterName()) < 1 {
		err := RedisSentinelCFValidationError{
			field:  "MasterName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetAddresses()) < 1 {
		err := RedisSentinelCFValidationError{
			field:  "Addresses",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetAddresses() {
		_, _ = idx, item

		if len(item) < 1 {
			err := RedisSentinelCFValidationError{
				field:  fmt.Sprintf("Addresses[%v]", idx),
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	// no validation rules for SentinelPasswordFile

	if len(errors) > 0 {
		return RedisSentinelCFMultiError(errors)
	}

	return nil
}

// RedisSentinelCFMultiError is an error wrapping multiple validation errors
// returned by RedisSentinelCF.ValidateAll() if the designated constraints
// aren't met.
type RedisSentinelCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisSentinelCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisSentinelCFMultiError) AllErrors() []error { return m }

// RedisSentinelCFValidationError is the validation error returned by
// RedisSentinelCF.Validate if the designated constraints aren't met.
type RedisSentinelCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisSentinelCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisSentinelCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisSentinelCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisSentinelCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisSentinelCFValidationError) ErrorName() string { return "RedisSentinelCFValidationError" }

// Error satisfies the builtin error interface
func (e RedisSentinelCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisSentinelCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisSentinelCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisSentinelCFValidationError{}

// Validate checks the field values on ListenApiCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ListenApiCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenApiCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ListenApiCFMultiError, or
// nil if none found.
func (m *ListenApiCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenApiCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Address

	if len(m.GetAuthenticationSecretFile()) < 1 {
		err := ListenApiCFValidationError{
			field:  "AuthenticationSecretFile",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	if d := m.GetMaxConnectionAge(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenApiCFValidationError{
				field:  "MaxConnectionAge",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenApiCFValidationError{
					field:  "MaxConnectionAge",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetListenGracePeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenApiCFValidationError{
				field:  "ListenGracePeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenApiCFValidationError{
					field:  "ListenGracePeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if m.Network != nil {

		if _, ok := _ListenApiCF_Network_InLookup[m.GetNetwork()]; !ok {
			err := ListenApiCFValidationError{
				field:  "Network",
				reason: "value must be in list [tcp tcp4 tcp6 unix]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ListenApiCFMultiError(errors)
	}

	return nil
}

// ListenApiCFMultiError is an error wrapping multiple validation errors
// returned by ListenApiCF.ValidateAll() if the designated constraints aren't met.
type ListenApiCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenApiCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenApiCFMultiError) AllErrors() []error { return m }

// ListenApiCFValidationError is the validation error returned by
// ListenApiCF.Validate if the designated constraints aren't met.
type ListenApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenApiCFValidationError) ErrorName() string { return "ListenApiCFValidationError" }

// Error satisfies the builtin error interface
func (e ListenApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenApiCFValidationError{}

var _ListenApiCF_Network_InLookup = map[string]struct{}{
	"tcp":  {},
	"tcp4": {},
	"tcp6": {},
	"unix": {},
}

// Validate checks the field values on ListenPrivateApiCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ListenPrivateApiCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenPrivateApiCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListenPrivateApiCFMultiError, or nil if none found.
func (m *ListenPrivateApiCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenPrivateApiCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Address

	if len(m.GetAuthenticationSecretFile()) < 1 {
		err := ListenPrivateApiCFValidationError{
			field:  "AuthenticationSecretFile",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for CertificateFile

	// no validation rules for KeyFile

	if d := m.GetMaxConnectionAge(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenPrivateApiCFValidationError{
				field:  "MaxConnectionAge",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenPrivateApiCFValidationError{
					field:  "MaxConnectionAge",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	// no validation rules for CaCertificateFile

	if d := m.GetListenGracePeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ListenPrivateApiCFValidationError{
				field:  "ListenGracePeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ListenPrivateApiCFValidationError{
					field:  "ListenGracePeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if m.Network != nil {

		if _, ok := _ListenPrivateApiCF_Network_InLookup[m.GetNetwork()]; !ok {
			err := ListenPrivateApiCFValidationError{
				field:  "Network",
				reason: "value must be in list [tcp tcp4 tcp6 unix]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ListenPrivateApiCFMultiError(errors)
	}

	return nil
}

// ListenPrivateApiCFMultiError is an error wrapping multiple validation errors
// returned by ListenPrivateApiCF.ValidateAll() if the designated constraints
// aren't met.
type ListenPrivateApiCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenPrivateApiCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenPrivateApiCFMultiError) AllErrors() []error { return m }

// ListenPrivateApiCFValidationError is the validation error returned by
// ListenPrivateApiCF.Validate if the designated constraints aren't met.
type ListenPrivateApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenPrivateApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenPrivateApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenPrivateApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenPrivateApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenPrivateApiCFValidationError) ErrorName() string {
	return "ListenPrivateApiCFValidationError"
}

// Error satisfies the builtin error interface
func (e ListenPrivateApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenPrivateApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenPrivateApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenPrivateApiCFValidationError{}

var _ListenPrivateApiCF_Network_InLookup = map[string]struct{}{
	"tcp":  {},
	"tcp4": {},
	"tcp6": {},
	"unix": {},
}

// Validate checks the field values on ApiCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ApiCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ApiCF with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ApiCFMultiError, or nil if none found.
func (m *ApiCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ApiCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetListen() == nil {
		err := ApiCFValidationError{
			field:  "Listen",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetListen()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ApiCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ApiCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ApiCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ApiCFMultiError(errors)
	}

	return nil
}

// ApiCFMultiError is an error wrapping multiple validation errors returned by
// ApiCF.ValidateAll() if the designated constraints aren't met.
type ApiCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ApiCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ApiCFMultiError) AllErrors() []error { return m }

// ApiCFValidationError is the validation error returned by ApiCF.Validate if
// the designated constraints aren't met.
type ApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApiCFValidationError) ErrorName() string { return "ApiCFValidationError" }

// Error satisfies the builtin error interface
func (e ApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApiCFValidationError{}

// Validate checks the field values on PrivateApiCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *PrivateApiCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PrivateApiCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in PrivateApiCFMultiError, or
// nil if none found.
func (m *PrivateApiCF) ValidateAll() error {
	return m.validate(true)
}

func (m *PrivateApiCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetListen() == nil {
		err := PrivateApiCFValidationError{
			field:  "Listen",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetListen()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, PrivateApiCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, PrivateApiCFValidationError{
					field:  "Listen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetListen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return PrivateApiCFValidationError{
				field:  "Listen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return PrivateApiCFMultiError(errors)
	}

	return nil
}

// PrivateApiCFMultiError is an error wrapping multiple validation errors
// returned by PrivateApiCF.ValidateAll() if the designated constraints aren't met.
type PrivateApiCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PrivateApiCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PrivateApiCFMultiError) AllErrors() []error { return m }

// PrivateApiCFValidationError is the validation error returned by
// PrivateApiCF.Validate if the designated constraints aren't met.
type PrivateApiCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PrivateApiCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PrivateApiCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PrivateApiCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PrivateApiCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PrivateApiCFValidationError) ErrorName() string { return "PrivateApiCFValidationError" }

// Error satisfies the builtin error interface
func (e PrivateApiCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPrivateApiCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PrivateApiCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PrivateApiCFValidationError{}

// Validate checks the field values on ConfigCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ConfigCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ConfigCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ConfigCFMultiError, or nil
// if none found.
func (m *ConfigCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ConfigCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Command

	if len(errors) > 0 {
		return ConfigCFMultiError(errors)
	}

	return nil
}

// ConfigCFMultiError is an error wrapping multiple validation errors returned
// by ConfigCF.ValidateAll() if the designated constraints aren't met.
type ConfigCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfigCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfigCFMultiError) AllErrors() []error { return m }

// ConfigCFValidationError is the validation error returned by
// ConfigCF.Validate if the designated constraints aren't met.
type ConfigCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigCFValidationError) ErrorName() string { return "ConfigCFValidationError" }

// Error satisfies the builtin error interface
func (e ConfigCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfigCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigCFValidationError{}

// Validate checks the field values on ConfigurationFile with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ConfigurationFile) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ConfigurationFile with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ConfigurationFileMultiError, or nil if none found.
func (m *ConfigurationFile) ValidateAll() error {
	return m.validate(true)
}

func (m *ConfigurationFile) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetGitlab() == nil {
		err := ConfigurationFileValidationError{
			field:  "Gitlab",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetGitlab()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Gitlab",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Gitlab",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitlab()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Gitlab",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAgent()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Agent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Agent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAgent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Agent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetObservability()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Observability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Observability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetObservability()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Observability",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGitaly()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Gitaly",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Gitaly",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitaly()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Gitaly",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetRedis() == nil {
		err := ConfigurationFileValidationError{
			field:  "Redis",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRedis()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Redis",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Redis",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRedis()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Redis",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetApi() == nil {
		err := ConfigurationFileValidationError{
			field:  "Api",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetApi()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Api",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Api",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetApi()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Api",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetPrivateApi() == nil {
		err := ConfigurationFileValidationError{
			field:  "PrivateApi",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetPrivateApi()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "PrivateApi",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "PrivateApi",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrivateApi()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "PrivateApi",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Config",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ConfigurationFileMultiError(errors)
	}

	return nil
}

// ConfigurationFileMultiError is an error wrapping multiple validation errors
// returned by ConfigurationFile.ValidateAll() if the designated constraints
// aren't met.
type ConfigurationFileMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfigurationFileMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfigurationFileMultiError) AllErrors() []error { return m }

// ConfigurationFileValidationError is the validation error returned by
// ConfigurationFile.Validate if the designated constraints aren't met.
type ConfigurationFileValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigurationFileValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigurationFileValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigurationFileValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigurationFileValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigurationFileValidationError) ErrorName() string {
	return "ConfigurationFileValidationError"
}

// Error satisfies the builtin error interface
func (e ConfigurationFileValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfigurationFile.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigurationFileValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigurationFileValidationError{}
